/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class RegistrationResult {
    @NonNull
    private final PublicKeyCredentialDescriptor keyId;
    private final boolean attestationTrusted;
    @NonNull
    private final AttestationType attestationType;
    @NonNull
    private final ByteArray publicKeyCose;
    @NonNull
    private final List<String> warnings;
    private final Attestation attestationMetadata;

    @JsonCreator
    private RegistrationResult(@JsonProperty(value="keyId") @NonNull PublicKeyCredentialDescriptor keyId, @JsonProperty(value="attestationTrusted") boolean attestationTrusted, @JsonProperty(value="attestationType") @NonNull AttestationType attestationType, @JsonProperty(value="publicKeyCose") @NonNull ByteArray publicKeyCose, @JsonProperty(value="warnings") @NonNull List<String> warnings, @JsonProperty(value="attestationMetadata") Attestation attestationMetadata) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked non-null but is null");
        }
        this.keyId = keyId;
        this.attestationTrusted = attestationTrusted;
        this.attestationType = attestationType;
        this.publicKeyCose = publicKeyCose;
        this.warnings = CollectionUtil.immutableList(warnings);
        this.attestationMetadata = attestationMetadata;
    }

    public Optional<Attestation> getAttestationMetadata() {
        return Optional.ofNullable(this.attestationMetadata);
    }

    static RegistrationResultBuilder.MandatoryStages builder() {
        return new RegistrationResultBuilder.MandatoryStages();
    }

    @Generated
    private static List<String> $default$warnings() {
        return Collections.emptyList();
    }

    @Generated
    public RegistrationResultBuilder toBuilder() {
        return new RegistrationResultBuilder().keyId(this.keyId).attestationTrusted(this.attestationTrusted).attestationType(this.attestationType).publicKeyCose(this.publicKeyCose).warnings(this.warnings).attestationMetadata(this.attestationMetadata);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialDescriptor getKeyId() {
        return this.keyId;
    }

    @Generated
    public boolean isAttestationTrusted() {
        return this.attestationTrusted;
    }

    @NonNull
    @Generated
    public AttestationType getAttestationType() {
        return this.attestationType;
    }

    @NonNull
    @Generated
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @NonNull
    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationResult)) {
            return false;
        }
        RegistrationResult other = (RegistrationResult)o;
        if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
            return false;
        }
        PublicKeyCredentialDescriptor this$keyId = this.getKeyId();
        PublicKeyCredentialDescriptor other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId)) {
            return false;
        }
        AttestationType this$attestationType = this.getAttestationType();
        AttestationType other$attestationType = other.getAttestationType();
        if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
        Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
        return !(this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
        PublicKeyCredentialDescriptor $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
        AttestationType $attestationType = this.getAttestationType();
        result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
        result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationResult(keyId=" + this.getKeyId() + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", publicKeyCose=" + this.getPublicKeyCose() + ", warnings=" + this.getWarnings() + ", attestationMetadata=" + this.getAttestationMetadata() + ")";
    }

    static class RegistrationResultBuilder {
        @Generated
        private PublicKeyCredentialDescriptor keyId;
        @Generated
        private boolean attestationTrusted;
        @Generated
        private AttestationType attestationType;
        @Generated
        private ByteArray publicKeyCose;
        @Generated
        private boolean warnings$set;
        @Generated
        private List<String> warnings$value;
        @Generated
        private Attestation attestationMetadata;

        RegistrationResultBuilder attestationMetadata(@NonNull Optional<Attestation> attestationMetadata) {
            if (attestationMetadata == null) {
                throw new NullPointerException("attestationMetadata is marked non-null but is null");
            }
            this.attestationMetadata = attestationMetadata.orElse(null);
            return this;
        }

        private RegistrationResultBuilder attestationMetadata(Attestation attestationMetadata) {
            return this.attestationMetadata(Optional.ofNullable(attestationMetadata));
        }

        @Generated
        RegistrationResultBuilder() {
        }

        @Generated
        public RegistrationResultBuilder keyId(@NonNull PublicKeyCredentialDescriptor keyId) {
            if (keyId == null) {
                throw new NullPointerException("keyId is marked non-null but is null");
            }
            this.keyId = keyId;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationTrusted(boolean attestationTrusted) {
            this.attestationTrusted = attestationTrusted;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationType(@NonNull AttestationType attestationType) {
            if (attestationType == null) {
                throw new NullPointerException("attestationType is marked non-null but is null");
            }
            this.attestationType = attestationType;
            return this;
        }

        @Generated
        public RegistrationResultBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        @Generated
        public RegistrationResultBuilder warnings(@NonNull List<String> warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked non-null but is null");
            }
            this.warnings$value = warnings;
            this.warnings$set = true;
            return this;
        }

        @Generated
        public RegistrationResult build() {
            List warnings$value = this.warnings$value;
            if (!this.warnings$set) {
                warnings$value = RegistrationResult.$default$warnings();
            }
            return new RegistrationResult(this.keyId, this.attestationTrusted, this.attestationType, this.publicKeyCose, warnings$value, this.attestationMetadata);
        }

        @Generated
        public String toString() {
            return "RegistrationResult.RegistrationResultBuilder(keyId=" + this.keyId + ", attestationTrusted=" + this.attestationTrusted + ", attestationType=" + (Object)((Object)this.attestationType) + ", publicKeyCose=" + this.publicKeyCose + ", warnings$value=" + this.warnings$value + ", attestationMetadata=" + this.attestationMetadata + ")";
        }

        static class MandatoryStages {
            private RegistrationResultBuilder builder = new RegistrationResultBuilder();

            MandatoryStages() {
            }

            Step2 keyId(PublicKeyCredentialDescriptor keyId) {
                this.builder.keyId(keyId);
                return new Step2();
            }

            class Step4 {
                Step4() {
                }

                RegistrationResultBuilder publicKeyCose(ByteArray publicKeyCose) {
                    return MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                }
            }

            class Step3 {
                Step3() {
                }

                Step4 attestationType(AttestationType attestationType) {
                    MandatoryStages.this.builder.attestationType(attestationType);
                    return new Step4();
                }
            }

            class Step2 {
                Step2() {
                }

                Step3 attestationTrusted(boolean attestationTrusted) {
                    MandatoryStages.this.builder.attestationTrusted(attestationTrusted);
                    return new Step3();
                }
            }
        }
    }
}

