/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import COSE.OneKey;
import com.google.common.primitives.Bytes;
import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Optional;

final class WebAuthnCodecs {
    private static final ByteArray ED25519_CURVE_OID = new ByteArray(new byte[]{48, 5, 6, 3, 43, 101, 112});

    WebAuthnCodecs() {
    }

    static ByteArray ecPublicKeyToRaw(ECPublicKey key) {
        byte[] x = key.getW().getAffineX().toByteArray();
        byte[] y = key.getW().getAffineY().toByteArray();
        byte[] xPadding = new byte[Math.max(0, 32 - x.length)];
        byte[] yPadding = new byte[Math.max(0, 32 - y.length)];
        Arrays.fill(xPadding, (byte)0);
        Arrays.fill(yPadding, (byte)0);
        return new ByteArray(Bytes.concat((byte[][])new byte[][]{{4}, Bytes.concat((byte[][])new byte[][]{xPadding, Arrays.copyOfRange(x, Math.max(0, x.length - 32), x.length)}), Bytes.concat((byte[][])new byte[][]{yPadding, Arrays.copyOfRange(y, Math.max(0, y.length - 32), y.length)})}));
    }

    static PublicKey importCosePublicKey(ByteArray key) throws CoseException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        CBORObject cose = CBORObject.DecodeFromBytes((byte[])key.getBytes());
        int kty = cose.get(CBORObject.FromObject((int)1)).AsInt32();
        switch (kty) {
            case 1: {
                return WebAuthnCodecs.importCoseEdDsaPublicKey(cose);
            }
            case 2: {
                return WebAuthnCodecs.importCoseP256PublicKey(cose);
            }
            case 3: {
                return WebAuthnCodecs.importCoseRsaPublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + kty);
    }

    private static PublicKey importCoseRsaPublicKey(CBORObject cose) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, cose.get(CBORObject.FromObject((int)-1)).GetByteString()), new BigInteger(1, cose.get(CBORObject.FromObject((int)-2)).GetByteString()));
        return Crypto.getKeyFactory("RSA").generatePublic(spec);
    }

    private static ECPublicKey importCoseP256PublicKey(CBORObject cose) throws CoseException {
        return (ECPublicKey)new OneKey(cose).AsPublicKey();
    }

    private static PublicKey importCoseEdDsaPublicKey(CBORObject cose) throws InvalidKeySpecException, NoSuchAlgorithmException {
        int curveId = cose.get(CBORObject.FromObject((int)-1)).AsInt32();
        switch (curveId) {
            case 6: {
                return WebAuthnCodecs.importCoseEd25519PublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported EdDSA curve: " + curveId);
    }

    private static PublicKey importCoseEd25519PublicKey(CBORObject cose) throws InvalidKeySpecException, NoSuchAlgorithmException {
        ByteArray rawKey = new ByteArray(cose.get(CBORObject.FromObject((int)-2)).GetByteString());
        ByteArray x509Key = new ByteArray(new byte[]{48, (byte)(ED25519_CURVE_OID.size() + 3 + rawKey.size())}).concat(ED25519_CURVE_OID).concat(new ByteArray(new byte[]{3, (byte)(rawKey.size() + 1), 0})).concat(rawKey);
        KeyFactory kFact = Crypto.getKeyFactory("EdDSA");
        return kFact.generatePublic(new X509EncodedKeySpec(x509Key.getBytes()));
    }

    static Optional<COSEAlgorithmIdentifier> getCoseKeyAlg(ByteArray key) {
        CBORObject cose = CBORObject.DecodeFromBytes((byte[])key.getBytes());
        int alg = cose.get(CBORObject.FromObject((int)3)).AsInt32();
        return COSEAlgorithmIdentifier.fromId(alg);
    }

    static String getJavaAlgorithmName(COSEAlgorithmIdentifier alg) {
        switch (alg) {
            case EdDSA: {
                return "EDDSA";
            }
            case ES256: {
                return "SHA256withECDSA";
            }
            case RS256: {
                return "SHA256withRSA";
            }
            case RS1: {
                return "SHA1withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + (Object)((Object)alg));
    }

    static String jwsAlgorithmNameToJavaAlgorithmName(String alg) {
        switch (alg) {
            case "RS256": {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + alg);
    }
}

