/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.attestation.Transport;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;

public final class Attestation
implements Serializable {
    private final boolean trusted;
    private final String metadataIdentifier;
    private final Map<String, String> vendorProperties;
    private final Map<String, String> deviceProperties;
    private final Set<Transport> transports;

    @JsonCreator
    private Attestation(@JsonProperty(value="trusted") boolean trusted, @JsonProperty(value="metadataIdentifier") String metadataIdentifier, @JsonProperty(value="vendorProperties") Map<String, String> vendorProperties, @JsonProperty(value="deviceProperties") Map<String, String> deviceProperties, @JsonProperty(value="transports") Set<Transport> transports) {
        this.trusted = trusted;
        this.metadataIdentifier = metadataIdentifier;
        this.vendorProperties = vendorProperties;
        this.deviceProperties = deviceProperties;
        this.transports = transports == null ? null : new TreeSet<Transport>(transports);
    }

    public Optional<String> getMetadataIdentifier() {
        return Optional.ofNullable(this.metadataIdentifier);
    }

    public Optional<Map<String, String>> getVendorProperties() {
        return Optional.ofNullable(this.vendorProperties);
    }

    public Optional<Map<String, String>> getDeviceProperties() {
        return Optional.ofNullable(this.deviceProperties);
    }

    public Optional<Set<Transport>> getTransports() {
        return Optional.ofNullable(this.transports);
    }

    public static Attestation empty() {
        return Attestation.builder().trusted(false).build();
    }

    public static AttestationBuilder.MandatoryStages builder() {
        return new AttestationBuilder.MandatoryStages();
    }

    @Generated
    public AttestationBuilder toBuilder() {
        return new AttestationBuilder().trusted(this.trusted).metadataIdentifier(this.metadataIdentifier).vendorProperties(this.vendorProperties).deviceProperties(this.deviceProperties).transports(this.transports);
    }

    @Generated
    public boolean isTrusted() {
        return this.trusted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attestation)) {
            return false;
        }
        Attestation other = (Attestation)o;
        if (this.isTrusted() != other.isTrusted()) {
            return false;
        }
        Optional<String> this$metadataIdentifier = this.getMetadataIdentifier();
        Optional<String> other$metadataIdentifier = other.getMetadataIdentifier();
        if (this$metadataIdentifier == null ? other$metadataIdentifier != null : !((Object)this$metadataIdentifier).equals(other$metadataIdentifier)) {
            return false;
        }
        Optional<Map<String, String>> this$vendorProperties = this.getVendorProperties();
        Optional<Map<String, String>> other$vendorProperties = other.getVendorProperties();
        if (this$vendorProperties == null ? other$vendorProperties != null : !((Object)this$vendorProperties).equals(other$vendorProperties)) {
            return false;
        }
        Optional<Map<String, String>> this$deviceProperties = this.getDeviceProperties();
        Optional<Map<String, String>> other$deviceProperties = other.getDeviceProperties();
        if (this$deviceProperties == null ? other$deviceProperties != null : !((Object)this$deviceProperties).equals(other$deviceProperties)) {
            return false;
        }
        Optional<Set<Transport>> this$transports = this.getTransports();
        Optional<Set<Transport>> other$transports = other.getTransports();
        return !(this$transports == null ? other$transports != null : !((Object)this$transports).equals(other$transports));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrusted() ? 79 : 97);
        Optional<String> $metadataIdentifier = this.getMetadataIdentifier();
        result = result * 59 + ($metadataIdentifier == null ? 43 : ((Object)$metadataIdentifier).hashCode());
        Optional<Map<String, String>> $vendorProperties = this.getVendorProperties();
        result = result * 59 + ($vendorProperties == null ? 43 : ((Object)$vendorProperties).hashCode());
        Optional<Map<String, String>> $deviceProperties = this.getDeviceProperties();
        result = result * 59 + ($deviceProperties == null ? 43 : ((Object)$deviceProperties).hashCode());
        Optional<Set<Transport>> $transports = this.getTransports();
        result = result * 59 + ($transports == null ? 43 : ((Object)$transports).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Attestation(trusted=" + this.isTrusted() + ", metadataIdentifier=" + this.getMetadataIdentifier() + ", vendorProperties=" + this.getVendorProperties() + ", deviceProperties=" + this.getDeviceProperties() + ", transports=" + this.getTransports() + ")";
    }

    public static class AttestationBuilder {
        private boolean trusted;
        private String metadataIdentifier;
        private Map<String, String> vendorProperties;
        private Map<String, String> deviceProperties;
        private Set<Transport> transports;

        public AttestationBuilder metadataIdentifier(@NonNull Optional<String> metadataIdentifier) {
            if (metadataIdentifier == null) {
                throw new NullPointerException("metadataIdentifier is marked non-null but is null");
            }
            return this.metadataIdentifier((String)metadataIdentifier.orElse(null));
        }

        public AttestationBuilder metadataIdentifier(String metadataIdentifier) {
            this.metadataIdentifier = metadataIdentifier;
            return this;
        }

        public AttestationBuilder vendorProperties(@NonNull Optional<Map<String, String>> vendorProperties) {
            if (vendorProperties == null) {
                throw new NullPointerException("vendorProperties is marked non-null but is null");
            }
            return this.vendorProperties((Map<String, String>)vendorProperties.orElse(null));
        }

        public AttestationBuilder vendorProperties(Map<String, String> vendorProperties) {
            this.vendorProperties = vendorProperties;
            return this;
        }

        public AttestationBuilder deviceProperties(@NonNull Optional<Map<String, String>> deviceProperties) {
            if (deviceProperties == null) {
                throw new NullPointerException("deviceProperties is marked non-null but is null");
            }
            return this.deviceProperties((Map<String, String>)deviceProperties.orElse(null));
        }

        public AttestationBuilder deviceProperties(Map<String, String> deviceProperties) {
            this.deviceProperties = deviceProperties;
            return this;
        }

        public AttestationBuilder transports(@NonNull Optional<Set<Transport>> transports) {
            if (transports == null) {
                throw new NullPointerException("transports is marked non-null but is null");
            }
            return this.transports((Set<Transport>)transports.orElse(null));
        }

        public AttestationBuilder transports(Set<Transport> transports) {
            this.transports = transports;
            return this;
        }

        @Generated
        AttestationBuilder() {
        }

        @Generated
        public AttestationBuilder trusted(boolean trusted) {
            this.trusted = trusted;
            return this;
        }

        @Generated
        public Attestation build() {
            return new Attestation(this.trusted, this.metadataIdentifier, this.vendorProperties, this.deviceProperties, this.transports);
        }

        @Generated
        public String toString() {
            return "Attestation.AttestationBuilder(trusted=" + this.trusted + ", metadataIdentifier=" + this.metadataIdentifier + ", vendorProperties=" + this.vendorProperties + ", deviceProperties=" + this.deviceProperties + ", transports=" + this.transports + ")";
        }

        public static class MandatoryStages {
            private final AttestationBuilder builder = new AttestationBuilder();

            public AttestationBuilder trusted(boolean trusted) {
                return this.builder.trusted(trusted);
            }
        }
    }
}

