/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.RegistrationExtensionInputs;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialCreationOptions {
    @NonNull
    private final RelyingPartyIdentity rp;
    @NonNull
    private final UserIdentity user;
    @NonNull
    private final ByteArray challenge;
    @NonNull
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final Long timeout;
    private final Set<PublicKeyCredentialDescriptor> excludeCredentials;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    @NonNull
    private final AttestationConveyancePreference attestation;
    @NonNull
    private final RegistrationExtensionInputs extensions;

    @JsonCreator
    private PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") @NonNull RelyingPartyIdentity rp, @JsonProperty(value="user") @NonNull UserIdentity user, @JsonProperty(value="challenge") @NonNull ByteArray challenge, @JsonProperty(value="pubKeyCredParams") @NonNull List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="excludeCredentials") Set<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="attestation") AttestationConveyancePreference attestation, @JsonProperty(value="extensions") RegistrationExtensionInputs extensions) {
        if (rp == null) {
            throw new NullPointerException("rp is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        if (pubKeyCredParams == null) {
            throw new NullPointerException("pubKeyCredParams is marked non-null but is null");
        }
        this.rp = rp;
        this.user = user;
        this.challenge = challenge;
        this.pubKeyCredParams = CollectionUtil.immutableList(pubKeyCredParams);
        this.timeout = timeout;
        this.excludeCredentials = excludeCredentials == null ? null : CollectionUtil.immutableSortedSet(new TreeSet<PublicKeyCredentialDescriptor>(excludeCredentials));
        this.authenticatorSelection = authenticatorSelection;
        this.attestation = attestation == null ? AttestationConveyancePreference.NONE : attestation;
        this.extensions = extensions == null ? RegistrationExtensionInputs.builder().build() : extensions;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<Set<PublicKeyCredentialDescriptor>> getExcludeCredentials() {
        return Optional.ofNullable(this.excludeCredentials);
    }

    public Optional<AuthenticatorSelectionCriteria> getAuthenticatorSelection() {
        return Optional.ofNullable(this.authenticatorSelection);
    }

    public static PublicKeyCredentialCreationOptionsBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialCreationOptionsBuilder.MandatoryStages();
    }

    @Generated
    public PublicKeyCredentialCreationOptionsBuilder toBuilder() {
        return new PublicKeyCredentialCreationOptionsBuilder().rp(this.rp).user(this.user).challenge(this.challenge).pubKeyCredParams(this.pubKeyCredParams).timeout(this.timeout).excludeCredentials(this.excludeCredentials).authenticatorSelection(this.authenticatorSelection).attestation(this.attestation).extensions(this.extensions);
    }

    @NonNull
    @Generated
    public RelyingPartyIdentity getRp() {
        return this.rp;
    }

    @NonNull
    @Generated
    public UserIdentity getUser() {
        return this.user;
    }

    @NonNull
    @Generated
    public ByteArray getChallenge() {
        return this.challenge;
    }

    @NonNull
    @Generated
    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    @NonNull
    @Generated
    public AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    @NonNull
    @Generated
    public RegistrationExtensionInputs getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialCreationOptions)) {
            return false;
        }
        PublicKeyCredentialCreationOptions other = (PublicKeyCredentialCreationOptions)o;
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        RelyingPartyIdentity this$rp = this.getRp();
        RelyingPartyIdentity other$rp = other.getRp();
        if (this$rp == null ? other$rp != null : !((Object)this$rp).equals(other$rp)) {
            return false;
        }
        UserIdentity this$user = this.getUser();
        UserIdentity other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        ByteArray this$challenge = this.getChallenge();
        ByteArray other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !((Object)this$challenge).equals(other$challenge)) {
            return false;
        }
        List<PublicKeyCredentialParameters> this$pubKeyCredParams = this.getPubKeyCredParams();
        List<PublicKeyCredentialParameters> other$pubKeyCredParams = other.getPubKeyCredParams();
        if (this$pubKeyCredParams == null ? other$pubKeyCredParams != null : !((Object)this$pubKeyCredParams).equals(other$pubKeyCredParams)) {
            return false;
        }
        Optional<Set<PublicKeyCredentialDescriptor>> this$excludeCredentials = this.getExcludeCredentials();
        Optional<Set<PublicKeyCredentialDescriptor>> other$excludeCredentials = other.getExcludeCredentials();
        if (this$excludeCredentials == null ? other$excludeCredentials != null : !((Object)this$excludeCredentials).equals(other$excludeCredentials)) {
            return false;
        }
        Optional<AuthenticatorSelectionCriteria> this$authenticatorSelection = this.getAuthenticatorSelection();
        Optional<AuthenticatorSelectionCriteria> other$authenticatorSelection = other.getAuthenticatorSelection();
        if (this$authenticatorSelection == null ? other$authenticatorSelection != null : !((Object)this$authenticatorSelection).equals(other$authenticatorSelection)) {
            return false;
        }
        AttestationConveyancePreference this$attestation = this.getAttestation();
        AttestationConveyancePreference other$attestation = other.getAttestation();
        if (this$attestation == null ? other$attestation != null : !((Object)((Object)this$attestation)).equals((Object)other$attestation)) {
            return false;
        }
        RegistrationExtensionInputs this$extensions = this.getExtensions();
        RegistrationExtensionInputs other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        RelyingPartyIdentity $rp = this.getRp();
        result = result * 59 + ($rp == null ? 43 : ((Object)$rp).hashCode());
        UserIdentity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        ByteArray $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : ((Object)$challenge).hashCode());
        List<PublicKeyCredentialParameters> $pubKeyCredParams = this.getPubKeyCredParams();
        result = result * 59 + ($pubKeyCredParams == null ? 43 : ((Object)$pubKeyCredParams).hashCode());
        Optional<Set<PublicKeyCredentialDescriptor>> $excludeCredentials = this.getExcludeCredentials();
        result = result * 59 + ($excludeCredentials == null ? 43 : ((Object)$excludeCredentials).hashCode());
        Optional<AuthenticatorSelectionCriteria> $authenticatorSelection = this.getAuthenticatorSelection();
        result = result * 59 + ($authenticatorSelection == null ? 43 : ((Object)$authenticatorSelection).hashCode());
        AttestationConveyancePreference $attestation = this.getAttestation();
        result = result * 59 + ($attestation == null ? 43 : ((Object)((Object)$attestation)).hashCode());
        RegistrationExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialCreationOptions(rp=" + this.getRp() + ", user=" + this.getUser() + ", challenge=" + this.getChallenge() + ", pubKeyCredParams=" + this.getPubKeyCredParams() + ", timeout=" + this.getTimeout() + ", excludeCredentials=" + this.getExcludeCredentials() + ", authenticatorSelection=" + this.getAuthenticatorSelection() + ", attestation=" + (Object)((Object)this.getAttestation()) + ", extensions=" + this.getExtensions() + ")";
    }

    public static class PublicKeyCredentialCreationOptionsBuilder {
        @Generated
        private RelyingPartyIdentity rp;
        @Generated
        private UserIdentity user;
        @Generated
        private ByteArray challenge;
        @Generated
        private List<PublicKeyCredentialParameters> pubKeyCredParams;
        @Generated
        private AttestationConveyancePreference attestation;
        @Generated
        private RegistrationExtensionInputs extensions;
        private Long timeout = null;
        private Set<PublicKeyCredentialDescriptor> excludeCredentials = null;
        private AuthenticatorSelectionCriteria authenticatorSelection = null;

        public PublicKeyCredentialCreationOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout.orElse(null);
            return this;
        }

        private PublicKeyCredentialCreationOptionsBuilder timeout(Long timeout) {
            return this.timeout(Optional.ofNullable(timeout));
        }

        public PublicKeyCredentialCreationOptionsBuilder timeout(long timeout) {
            return this.timeout(Optional.of(timeout));
        }

        public PublicKeyCredentialCreationOptionsBuilder excludeCredentials(Optional<Set<PublicKeyCredentialDescriptor>> excludeCredentials) {
            return this.excludeCredentials((Set<PublicKeyCredentialDescriptor>)excludeCredentials.orElse(null));
        }

        public PublicKeyCredentialCreationOptionsBuilder excludeCredentials(Set<PublicKeyCredentialDescriptor> excludeCredentials) {
            this.excludeCredentials = excludeCredentials;
            return this;
        }

        public PublicKeyCredentialCreationOptionsBuilder authenticatorSelection(@NonNull Optional<AuthenticatorSelectionCriteria> authenticatorSelection) {
            if (authenticatorSelection == null) {
                throw new NullPointerException("authenticatorSelection is marked non-null but is null");
            }
            return this.authenticatorSelection((AuthenticatorSelectionCriteria)authenticatorSelection.orElse(null));
        }

        public PublicKeyCredentialCreationOptionsBuilder authenticatorSelection(AuthenticatorSelectionCriteria authenticatorSelection) {
            this.authenticatorSelection = authenticatorSelection;
            return this;
        }

        @Generated
        PublicKeyCredentialCreationOptionsBuilder() {
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder rp(@NonNull RelyingPartyIdentity rp) {
            if (rp == null) {
                throw new NullPointerException("rp is marked non-null but is null");
            }
            this.rp = rp;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder user(@NonNull UserIdentity user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder challenge(@NonNull ByteArray challenge) {
            if (challenge == null) {
                throw new NullPointerException("challenge is marked non-null but is null");
            }
            this.challenge = challenge;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder pubKeyCredParams(@NonNull List<PublicKeyCredentialParameters> pubKeyCredParams) {
            if (pubKeyCredParams == null) {
                throw new NullPointerException("pubKeyCredParams is marked non-null but is null");
            }
            this.pubKeyCredParams = pubKeyCredParams;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder attestation(@NonNull AttestationConveyancePreference attestation) {
            if (attestation == null) {
                throw new NullPointerException("attestation is marked non-null but is null");
            }
            this.attestation = attestation;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptionsBuilder extensions(@NonNull RegistrationExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked non-null but is null");
            }
            this.extensions = extensions;
            return this;
        }

        @Generated
        public PublicKeyCredentialCreationOptions build() {
            return new PublicKeyCredentialCreationOptions(this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.attestation, this.extensions);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder(rp=" + this.rp + ", user=" + this.user + ", challenge=" + this.challenge + ", pubKeyCredParams=" + this.pubKeyCredParams + ", timeout=" + this.timeout + ", excludeCredentials=" + this.excludeCredentials + ", authenticatorSelection=" + this.authenticatorSelection + ", attestation=" + (Object)((Object)this.attestation) + ", extensions=" + this.extensions + ")";
        }

        public static class MandatoryStages {
            private PublicKeyCredentialCreationOptionsBuilder builder = new PublicKeyCredentialCreationOptionsBuilder();

            public Step2 rp(RelyingPartyIdentity rp) {
                this.builder.rp(rp);
                return new Step2();
            }

            public class Step4 {
                public PublicKeyCredentialCreationOptionsBuilder pubKeyCredParams(List<PublicKeyCredentialParameters> pubKeyCredParams) {
                    return MandatoryStages.this.builder.pubKeyCredParams(pubKeyCredParams);
                }
            }

            public class Step3 {
                public Step4 challenge(ByteArray challenge) {
                    MandatoryStages.this.builder.challenge(challenge);
                    return new Step4();
                }
            }

            public class Step2 {
                public Step3 user(UserIdentity user) {
                    MandatoryStages.this.builder.user(user);
                    return new Step3();
                }
            }
        }
    }
}

