/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonStringSerializer.class)
public enum AuthenticatorAttachment implements JsonStringSerializable
{
    CROSS_PLATFORM("cross-platform"),
    PLATFORM("platform");

    @NonNull
    private final String value;

    private static Optional<AuthenticatorAttachment> fromString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Stream.of(AuthenticatorAttachment.values()).filter(v -> v.value.equals(value)).findAny();
    }

    @JsonCreator
    private static AuthenticatorAttachment fromJsonString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return AuthenticatorAttachment.fromString(value).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", AuthenticatorAttachment.class.getSimpleName(), value)));
    }

    @Deprecated
    public String toJsonString() {
        return this.value;
    }

    @Generated
    private AuthenticatorAttachment(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }
}

