/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonLongSerializable;
import com.yubico.internal.util.json.JsonLongSerializer;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

@JsonSerialize(using=JsonLongSerializer.class)
public enum COSEAlgorithmIdentifier implements JsonLongSerializable
{
    EdDSA(-8L),
    ES256(-7L),
    RS256(-257L),
    RS1(-65535L);

    private final long id;

    private COSEAlgorithmIdentifier(long id) {
        this.id = id;
    }

    public static Optional<COSEAlgorithmIdentifier> fromId(long id) {
        return Stream.of(COSEAlgorithmIdentifier.values()).filter(v -> v.id == id).findAny();
    }

    @JsonCreator
    private static COSEAlgorithmIdentifier fromJson(long id) {
        return COSEAlgorithmIdentifier.fromId(id).orElseThrow(() -> new IllegalArgumentException("Unknown COSE algorithm identifier: " + id));
    }

    @Deprecated
    public long toJsonNumber() {
        return this.id;
    }

    @Generated
    public long getId() {
        return this.id;
    }
}

