/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonStringSerializer.class)
public enum UserVerificationRequirement implements JsonStringSerializable
{
    DISCOURAGED("discouraged"),
    PREFERRED("preferred"),
    REQUIRED("required");

    @NonNull
    private final String value;

    private static Optional<UserVerificationRequirement> fromString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Stream.of(UserVerificationRequirement.values()).filter(v -> v.value.equals(value)).findAny();
    }

    @JsonCreator
    private static UserVerificationRequirement fromJsonString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return UserVerificationRequirement.fromString(value).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", UserVerificationRequirement.class.getSimpleName(), value)));
    }

    @Deprecated
    public String toJsonString() {
        return this.value;
    }

    @Generated
    private UserVerificationRequirement(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }
}

