/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2.impl;

import com.yubico.client.v2.Signature;
import com.yubico.client.v2.YubicoClient;
import com.yubico.client.v2.YubicoResponse;
import com.yubico.client.v2.YubicoResponseStatus;
import com.yubico.client.v2.YubicoValidationService;
import com.yubico.client.v2.YubicoValidationTimeout;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YubicoClientImpl
extends YubicoClient {
    private static Logger logger = LoggerFactory.getLogger(YubicoClientImpl.class);

    public YubicoClientImpl(Integer id) {
        this.clientId = id;
    }

    public YubicoClientImpl(Integer id, String key) {
        this.clientId = id;
        this.setKey(key);
    }

    public YubicoClientImpl(Integer id, String key, String sync) {
        this.clientId = id;
        this.setKey(key);
        this.setSync(sync);
    }

    public YubicoResponse verify(String otp) {
        if (!YubicoClientImpl.isValidOTPFormat(otp)) {
            throw new IllegalArgumentException("The OTP is not a valid format");
        }
        try {
            String nonce = UUID.randomUUID().toString().replaceAll("-", "");
            String syncParam = "";
            if (this.sync != null) {
                syncParam = String.format("&sl=%s", this.sync);
            }
            String paramStr = String.format("id=%d&nonce=%s&otp=%s%s&timestamp=%s", this.clientId, nonce, otp, syncParam, "1");
            if (this.key != null) {
                String s = Signature.calculate(paramStr.toString(), this.key).replaceAll("\\+", "%2B");
                paramStr = paramStr + "&h=";
                paramStr = paramStr + s;
            }
            String[] wsapiUrls = this.getWsapiUrls();
            ArrayList<String> validationUrls = new ArrayList<String>();
            int len = wsapiUrls.length;
            for (int i = 0; i < len; ++i) {
                validationUrls.add(wsapiUrls[i] + "?" + paramStr);
            }
            YubicoResponse response = new YubicoValidationService().fetch(validationUrls);
            if (response == null) {
                throw new YubicoValidationTimeout("Timeout reached while waiting for valid answer.");
            }
            if (this.key != null) {
                StringBuffer keyValueStr = new StringBuffer();
                for (Map.Entry<String, String> entry : response.getKeyValueMap().entrySet()) {
                    if ("h".equals(entry.getKey())) continue;
                    if (keyValueStr.length() > 0) {
                        keyValueStr.append("&");
                    }
                    keyValueStr.append(entry.getKey()).append("=").append(entry.getValue());
                }
                String signature = Signature.calculate(keyValueStr.toString(), this.key).trim();
                if (!response.getH().equals(signature)) {
                    logger.warn("Signatures do not match");
                    return null;
                }
            }
            if (!this.isError(response.getStatus())) {
                if (response.getOtp() == null || !otp.equals(response.getOtp())) {
                    logger.warn("OTP mismatch in response, is there a man-in-the-middle?");
                    return null;
                }
                if (response.getNonce() == null || !nonce.equals(response.getNonce())) {
                    logger.warn("Nonce mismatch in response, is there a man-in-the-middle?");
                    return null;
                }
            }
            return response;
        }
        catch (Exception e) {
            logger.warn("Got exception when parsing response from server.", (Throwable)e);
            return null;
        }
    }

    private boolean isError(YubicoResponseStatus status) {
        return YubicoResponseStatus.BACKEND_ERROR.equals((Object)status) || YubicoResponseStatus.BAD_OTP.equals((Object)status) || YubicoResponseStatus.BAD_SIGNATURE.equals((Object)status) || YubicoResponseStatus.NO_SUCH_CLIENT.equals((Object)status) || YubicoResponseStatus.MISSING_PARAMETER.equals((Object)status);
    }
}

