/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2.impl;

import com.yubico.client.v2.YubicoResponse;
import com.yubico.client.v2.YubicoResponseStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YubicoResponseImpl
implements YubicoResponse {
    private String h;
    private String t;
    private YubicoResponseStatus status;
    private String timestamp;
    private String sessioncounter;
    private String sessionuse;
    private String sl;
    private String otp;
    private String nonce;
    private Map<String, String> keyValueMap = new TreeMap<String, String>();

    public YubicoResponseImpl(InputStream inStream) throws IOException {
        String inputLine;
        if (inStream == null) {
            throw new IOException("InputStream argument was null");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        while ((inputLine = in.readLine()) != null) {
            int ix = inputLine.indexOf("=");
            if (ix == -1) continue;
            String key = inputLine.substring(0, ix);
            String val = inputLine.substring(ix + 1);
            if ("h".equals(key)) {
                this.setH(val);
            } else if ("t".equals(key)) {
                this.setT(val);
            } else if ("otp".equals(key)) {
                this.setOtp(val);
            } else if ("status".equals(key)) {
                this.setStatus(YubicoResponseStatus.valueOf(val));
            } else if ("timestamp".equals(key)) {
                this.setTimestamp(val);
            } else if ("sessioncounter".equals(key)) {
                this.setSessioncounter(val);
            } else if ("sessionuse".equals(key)) {
                this.setSessionuse(val);
            } else if ("sl".equals(key)) {
                this.setSl(val);
            } else if ("nonce".equals(key)) {
                this.setNonce(val);
            }
            this.keyValueMap.put(key, val);
        }
        in.close();
    }

    @Override
    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    public String toString() {
        return this.otp + ":" + (Object)((Object)this.status);
    }

    @Override
    public String getH() {
        return this.h;
    }

    public void setH(String h) {
        this.h = h;
    }

    @Override
    public String getT() {
        return this.t;
    }

    public void setT(String t) {
        this.t = t;
    }

    @Override
    public YubicoResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(YubicoResponseStatus status) {
        this.status = status;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getSessioncounter() {
        return this.sessioncounter;
    }

    public void setSessioncounter(String sessioncounter) {
        this.sessioncounter = sessioncounter;
    }

    @Override
    public String getSessionuse() {
        return this.sessionuse;
    }

    public void setSessionuse(String sessionuse) {
        this.sessionuse = sessionuse;
    }

    @Override
    public String getSl() {
        return this.sl;
    }

    public void setSl(String sl) {
        this.sl = sl;
    }

    @Override
    public String getOtp() {
        return this.otp;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }
}

