/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.DateTimeHelper;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalDateTime;
import java.util.Date;

public class GraphQLDate
extends GraphQLScalarType {
    private static final String DEFAULT_NAME = "Date";

    public GraphQLDate() {
        this(DEFAULT_NAME);
    }

    public GraphQLDate(String name) {
        super(name, "Date type", (Coercing)new Coercing<Date, String>(){

            private Date convertImpl(Object input) {
                if (input instanceof String) {
                    LocalDateTime localDateTime = DateTimeHelper.parseDate((String)input);
                    if (localDateTime != null) {
                        return DateTimeHelper.toDate(localDateTime);
                    }
                } else if (input instanceof Date) {
                    return (Date)input;
                }
                return null;
            }

            public String serialize(Object input) {
                if (input instanceof Date) {
                    return DateTimeHelper.toISOString((Date)input);
                }
                Date result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingSerializeException("Invalid value '" + input + "' for Date");
                }
                return DateTimeHelper.toISOString(result);
            }

            public Date parseValue(Object input) {
                Date result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingParseValueException("Invalid value '" + input + "' for Date");
                }
                return result;
            }

            public Date parseLiteral(Object input) {
                String value = ((StringValue)input).getValue();
                Date result = this.convertImpl(value);
                if (result == null) {
                    throw new CoercingParseLiteralException("Invalid value '" + input + "' for Date");
                }
                return result;
            }
        });
    }
}

