/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.DateTimeHelper;
import com.zhokhov.graphql.datetime.LocalDateTimeConverter;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class GraphQLLocalDate
extends GraphQLScalarType {
    private static final String DEFAULT_NAME = "LocalDate";

    public GraphQLLocalDate() {
        this(DEFAULT_NAME, false, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public GraphQLLocalDate(boolean zoneConversionEnabled) {
        this(DEFAULT_NAME, zoneConversionEnabled, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public GraphQLLocalDate(String name, boolean zoneConversionEnabled) {
        this(name, zoneConversionEnabled, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public GraphQLLocalDate(String name, final boolean zoneConversionEnabled, final DateTimeFormatter formatter) {
        super(name != null ? name : DEFAULT_NAME, "Local Date type", (Coercing)new Coercing<LocalDate, String>(){
            private final LocalDateTimeConverter converter;
            {
                this.converter = new LocalDateTimeConverter(zoneConversionEnabled);
            }

            private LocalDate convertImpl(Object input) {
                if (input instanceof String) {
                    LocalDateTime localDateTime = this.converter.parseDate((String)input);
                    if (localDateTime != null) {
                        return localDateTime.toLocalDate();
                    }
                } else if (input instanceof LocalDate) {
                    return (LocalDate)input;
                }
                return null;
            }

            public String serialize(Object input) {
                if (input instanceof LocalDate) {
                    return this.converter.formatDate((LocalDate)input, formatter);
                }
                LocalDate result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingSerializeException("Invalid value '" + input + "' for LocalDate");
                }
                return this.converter.formatDate(result, formatter);
            }

            public LocalDate parseValue(Object input) {
                LocalDate result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingParseValueException("Invalid value '" + input + "' for LocalDate");
                }
                return result;
            }

            public LocalDate parseLiteral(Object input) {
                String value = ((StringValue)input).getValue();
                LocalDate result = this.convertImpl(value);
                if (result == null) {
                    throw new CoercingParseLiteralException("Invalid value '" + input + "' for LocalDate");
                }
                return result;
            }
        });
        if (!DateTimeHelper.DATE_FORMATTERS.contains(formatter)) {
            DateTimeHelper.DATE_FORMATTERS.add(formatter);
        }
    }
}

