/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.DateTimeHelper;
import com.zhokhov.graphql.datetime.LocalDateTimeConverter;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class GraphQLLocalDateTime
extends GraphQLScalarType {
    private static final String DEFAULT_NAME = "LocalDateTime";

    public GraphQLLocalDateTime() {
        this(DEFAULT_NAME, false);
    }

    public GraphQLLocalDateTime(boolean zoneConversionEnabled) {
        this(DEFAULT_NAME, zoneConversionEnabled, DateTimeFormatter.ISO_INSTANT);
    }

    public GraphQLLocalDateTime(String name, boolean zoneConversionEnabled) {
        this(name, zoneConversionEnabled, DateTimeFormatter.ISO_INSTANT);
    }

    public GraphQLLocalDateTime(String name, final boolean zoneConversionEnabled, final DateTimeFormatter formatter) {
        super(name != null ? name : DEFAULT_NAME, "Local Date Time type", (Coercing)new Coercing<LocalDateTime, String>(){
            private final LocalDateTimeConverter converter;
            {
                this.converter = new LocalDateTimeConverter(zoneConversionEnabled);
            }

            private LocalDateTime convertImpl(Object input) {
                if (input instanceof String) {
                    LocalDateTime localDateTime = this.converter.parseDate((String)input);
                    if (localDateTime != null) {
                        return localDateTime;
                    }
                } else if (input instanceof LocalDateTime) {
                    return (LocalDateTime)input;
                }
                return null;
            }

            public String serialize(Object input) {
                if (input instanceof LocalDateTime) {
                    return this.converter.formatDate((LocalDateTime)input, formatter);
                }
                LocalDateTime result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingSerializeException("Invalid value '" + input + "' for LocalDateTime");
                }
                return this.converter.formatDate(result, formatter);
            }

            public LocalDateTime parseValue(Object input) {
                LocalDateTime result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingParseValueException("Invalid value '" + input + "' for LocalDateTime");
                }
                return result;
            }

            public LocalDateTime parseLiteral(Object input) {
                String value = ((StringValue)input).getValue();
                LocalDateTime result = this.convertImpl(value);
                if (result == null) {
                    throw new CoercingParseLiteralException("Invalid value '" + input + "' for LocalDateTime");
                }
                return result;
            }
        });
        if (!DateTimeHelper.DATE_FORMATTERS.contains(formatter)) {
            DateTimeHelper.DATE_FORMATTERS.add(formatter);
        }
    }
}

