/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.DateTimeHelper;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class GraphQLLocalTime
extends GraphQLScalarType {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME.withZone(ZoneOffset.UTC);
    private static final String DEFAULT_NAME = "LocalTime";

    public GraphQLLocalTime() {
        this(DEFAULT_NAME);
    }

    public GraphQLLocalTime(String name) {
        super(name, "Local Time type", (Coercing)new Coercing<LocalTime, String>(){

            private LocalTime convertImpl(Object input) {
                if (input instanceof String) {
                    try {
                        return LocalTime.parse((String)input, FORMATTER);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                    }
                } else if (input instanceof LocalTime) {
                    return (LocalTime)input;
                }
                return null;
            }

            public String serialize(Object input) {
                if (input instanceof LocalTime) {
                    return DateTimeHelper.toISOString((LocalTime)input);
                }
                LocalTime result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingSerializeException("Invalid value '" + input + "' for LocalTime");
                }
                return DateTimeHelper.toISOString(result);
            }

            public LocalTime parseValue(Object input) {
                LocalTime result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingParseValueException("Invalid value '" + input + "' for LocalTime");
                }
                return result;
            }

            public LocalTime parseLiteral(Object input) {
                String value = ((StringValue)input).getValue();
                LocalTime result = this.convertImpl(value);
                if (result == null) {
                    throw new CoercingParseLiteralException("Invalid value '" + input + "' for LocalTime");
                }
                return result;
            }
        });
    }
}

