/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static FastHashMap dummy = new FastHashMap();
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtils.class$("org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils));
    private static int debug = 0;
    static /* synthetic */ Class class$org$apache$commons$beanutils$BeanUtils;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cloning bean: " + bean.getClass().getName()));
        }
        Class<?> clazz = bean.getClass();
        Object newBean = clazz.newInstance();
        PropertyUtils.copyProperties(newBean, bean);
        return newBean;
    }

    public static Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Describing bean: " + bean.getClass().getName()));
        }
        if (bean == null) {
            return new HashMap();
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        HashMap<String, String> description = new HashMap<String, String>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            String name = descriptors[i].getName();
            if (descriptors[i].getReadMethod() != null) {
                description.put(name, BeanUtils.getProperty(bean, name));
            }
            ++i;
        }
        return description;
    }

    public static String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator items = ((Collection)value).iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(item.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (value.getClass().isArray()) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                int n = Array.getLength(value);
                int i = 0;
                while (i < n) {
                    Object item = Array.get(value, i);
                    if (item == null) {
                        values.add(null);
                    } else {
                        values.add(item.toString());
                    }
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            return values.toArray(new String[values.size()]);
        }
        String[] results = new String[]{value.toString()};
        return results;
    }

    public static String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name, index);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name, key);
        return ConvertUtils.convert(value);
    }

    public static String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getNestedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return BeanUtils.getNestedProperty(bean, name);
    }

    public static String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getSimpleProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static void populate(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BeanUtils.populate(" + bean + ", " + properties + ")"));
        }
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (name == null) continue;
            Object value = properties.get(name);
            BeanUtils.setProperty(bean, name, value);
        }
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        int j;
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("  setProperty(");
            sb.append(bean);
            sb.append(", ");
            sb.append(name);
            sb.append(", ");
            if (value == null) {
                sb.append("<NULL>");
            } else if (value instanceof String) {
                sb.append((String)value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                sb.append('[');
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                    ++i;
                }
                sb.append(']');
            } else {
                sb.append(value.toString());
            }
            sb.append(')');
            log.trace((Object)sb.toString());
        }
        Object target = bean;
        int delim = name.lastIndexOf(46);
        if (delim >= 0) {
            try {
                target = PropertyUtils.getProperty(bean, name.substring(0, delim));
            }
            catch (NoSuchMethodException e) {
                return;
            }
            name = name.substring(delim + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("    Target bean = " + target));
                log.trace((Object)("    Target name = " + name));
            }
        }
        String propName = null;
        Class<Object> type = null;
        int index = -1;
        String key = null;
        propName = name;
        int i = propName.indexOf(91);
        if (i >= 0) {
            int k = propName.indexOf(93);
            try {
                index = Integer.parseInt(propName.substring(i + 1, k));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            propName = propName.substring(0, i);
        }
        if ((j = propName.indexOf(40)) >= 0) {
            int k = propName.indexOf(41);
            try {
                key = propName.substring(j + 1, k);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            propName = propName.substring(0, j);
        }
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return;
            }
            type = dynaProperty.getType();
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = PropertyUtils.getPropertyDescriptor(target, name);
                if (descriptor == null) {
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                return;
            }
            type = descriptor instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)descriptor).getMappedPropertyType() : (descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType() : descriptor.getPropertyType());
        }
        Object newValue = null;
        if (type.isArray() && index < 0) {
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                newValue = ConvertUtils.convert(values, type);
            } else {
                newValue = value instanceof String[] ? ConvertUtils.convert((String[])value, type) : value;
            }
        } else {
            newValue = type.isArray() ? (value instanceof String ? ConvertUtils.convert((String)value, type.getComponentType()) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type.getComponentType()) : value)) : (value instanceof String ? ConvertUtils.convert((String)value, type) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type) : value));
        }
        try {
            if (index >= 0) {
                PropertyUtils.setIndexedProperty(target, propName, index, newValue);
            } else if (key != null) {
                PropertyUtils.setMappedProperty(target, propName, key, newValue);
            } else {
                PropertyUtils.setProperty(target, propName, newValue);
            }
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, "Cannot set " + propName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

