/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    private static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Matching name=" + methodName + " on " + clazz));
        }
        int paramSize = parameterTypes.length;
        Method[] methods = clazz.getMethods();
        int i = 0;
        int size = methods.length;
        while (i < size) {
            if (methods[i].getName().equals(methodName)) {
                Class<?>[] methodsParams;
                int methodParamSize;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Found matching name:");
                    log.trace((Object)methods[i]);
                }
                if ((methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) == paramSize) {
                    boolean match = true;
                    int n = 0;
                    while (n < methodParamSize) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Param=" + parameterTypes[n].getName()));
                            log.trace((Object)("Method=" + methodsParams[n].getName()));
                        }
                        if (!methodsParams[n].isAssignableFrom(parameterTypes[n])) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(methodsParams[n] + " is not assignable from " + parameterTypes[n]));
                            }
                            match = false;
                            break;
                        }
                        ++n;
                    }
                    if (match) {
                        Method method = MethodUtils.getAccessibleMethod(methods[i]);
                        if (method != null) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(method + " accessible version of " + methods[i]));
                            }
                            return method;
                        }
                        log.trace((Object)"Couldn't find accessible method.");
                    }
                }
            }
            ++i;
        }
        log.trace((Object)"No match found.");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

