/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (args == null) {
            args = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = emptyObjectArray;
        }
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        if (MethodUtils.log.isTraceEnabled()) {
            MethodUtils.log.trace((Object)("Matching name=" + methodName + " on " + clazz));
        }
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            if (MethodUtils.log.isTraceEnabled()) {
                MethodUtils.log.trace((Object)("Found straight match: " + method));
                MethodUtils.log.trace((Object)("isPublic:" + Modifier.isPublic(method.getModifiers())));
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException se) {
                if (!MethodUtils.loggedAccessibleWarning) {
                    MethodUtils.log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                    MethodUtils.loggedAccessibleWarning = true;
                }
                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)se);
            }
            return e;
        }
        catch (NoSuchMethodException e) {
            paramSize = parameterTypes.length;
            methods = clazz.getMethods();
            i = 0;
            size = methods.length;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            if (methods[i].getName().equals(methodName)) {
                if (MethodUtils.log.isTraceEnabled()) {
                    MethodUtils.log.trace((Object)"Found matching name:");
                    MethodUtils.log.trace((Object)methods[i]);
                }
                if ((methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) == paramSize) {
                    match = true;
                    n = 0;
                    while (n < methodParamSize) {
                        if (MethodUtils.log.isTraceEnabled()) {
                            MethodUtils.log.trace((Object)("Param=" + parameterTypes[n].getName()));
                            MethodUtils.log.trace((Object)("Method=" + methodsParams[n].getName()));
                        }
                        if (!MethodUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(methodsParams[n] + " is not assignable from " + parameterTypes[n]));
                            }
                            match = false;
                            break;
                        }
                        ++n;
                    }
                    if (match) {
                        method = MethodUtils.getAccessibleMethod(methods[i]);
                        if (method != null) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(method + " accessible version of " + methods[i]));
                            }
                            try {
                                method.setAccessible(true);
                            }
                            catch (SecurityException se) {
                                if (!MethodUtils.loggedAccessibleWarning) {
                                    MethodUtils.log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                                    MethodUtils.loggedAccessibleWarning = true;
                                }
                                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)se);
                            }
                            return method;
                        }
                        MethodUtils.log.trace((Object)"Couldn't find accessible method.");
                    }
                }
            }
            ++i;
            continue;
        }
lbl58:
        // 1 sources

        MethodUtils.log.trace((Object)"No match found.");
        return null;
    }

    protected static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            if (Boolean.TYPE.equals(parameterType)) {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(parameterization);
            }
            if (Float.TYPE.equals(parameterType)) {
                return (class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(parameterization);
            }
            if (Long.TYPE.equals(parameterType)) {
                return (class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(parameterization);
            }
            if (Integer.TYPE.equals(parameterType)) {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(parameterization);
            }
            if (Double.TYPE.equals(parameterType)) {
                return (class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(parameterization);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

