/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.codec.binary.BaseNCodec;

public class Base32TestData {
    static final String STRING_FIXTURE = "Hello World";
    static final String BASE32_FIXTURE = "JBSWY3DPEBLW64TMMQ======\r\n";
    private static final int SIZE_KEY = 0;
    private static final int LAST_READ_KEY = 1;

    static byte[] streamToBytes(InputStream in) throws IOException {
        return Base32TestData.streamToBytes(in, new byte[7]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] streamToBytes(InputStream in, byte[] buf) throws IOException {
        try {
            int[] status = Base32TestData.fill(buf, 0, in);
            int size = status[0];
            int lastRead = status[1];
            while (lastRead != -1) {
                buf = Base32TestData.resizeArray(buf);
                status = Base32TestData.fill(buf, size, in);
                size = status[0];
                lastRead = status[1];
            }
            if (buf.length != size) {
                byte[] smallerBuf = new byte[size];
                System.arraycopy(buf, 0, smallerBuf, 0, size);
                buf = smallerBuf;
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    private static int[] fill(byte[] buf, int offset, InputStream in) throws IOException {
        int read;
        int lastRead = read = in.read(buf, offset, buf.length - offset);
        if (read == -1) {
            read = 0;
        }
        while (lastRead != -1 && read + offset < buf.length) {
            lastRead = in.read(buf, offset + read, buf.length - read - offset);
            if (lastRead == -1) continue;
            read += lastRead;
        }
        return new int[]{offset + read, lastRead};
    }

    private static byte[] resizeArray(byte[] bytes) {
        byte[] biggerBytes = new byte[bytes.length * 2];
        System.arraycopy(bytes, 0, biggerBytes, 0, bytes.length);
        return biggerBytes;
    }

    static byte[][] randomData(BaseNCodec codec, int size) {
        Random r = new Random();
        byte[] decoded = new byte[size];
        r.nextBytes(decoded);
        byte[] encoded = codec.encode(decoded);
        return new byte[][]{decoded, encoded};
    }

    static boolean bytesContain(byte[] bytes, byte c) {
        for (byte b : bytes) {
            if (b != c) continue;
            return true;
        }
        return false;
    }
}

