/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.binary.Base64TestData;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base64OutputStreamTest {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testCodec98NPE() throws Exception {
        byte[] codec98 = StringUtils.getBytesUtf8((String)"YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWjAxMjM");
        byte[] codec98_1024 = new byte[1024];
        System.arraycopy(codec98, 0, codec98_1024, 0, codec98.length);
        ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
        Base64OutputStream stream = new Base64OutputStream((OutputStream)data, false);
        stream.write(codec98_1024, 0, 1024);
        stream.close();
        byte[] decodedBytes = data.toByteArray();
        String decoded = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assert.assertEquals((String)"codec-98 NPE Base64OutputStream", (Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123", (Object)decoded);
    }

    @Test
    public void testBase64EmptyOutputStreamMimeChunkSize() throws Exception {
        this.testBase64EmptyOutputStream(76);
    }

    @Test
    public void testBase64EmptyOutputStreamPemChunkSize() throws Exception {
        this.testBase64EmptyOutputStream(64);
    }

    private void testBase64EmptyOutputStream(int chunkSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chunkSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chunkSize, CRLF);
    }

    @Test
    public void testBase64OutputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = Base64TestData.DECODED;
        this.testByChunk(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replaceAll("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = Base64TestData.DECODED;
        this.testByChunk(encoded, decoded, 0, LF);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base64TestData.randomData(i, false);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    public void testBase64OutputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = Base64TestData.DECODED;
        this.testByteByByte(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replaceAll("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = Base64TestData.DECODED;
        this.testByteByByte(encoded, decoded, 0, LF);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base64TestData.randomData(i, false);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] seperator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Object out = new Base64OutputStream((OutputStream)byteOut, true, chunkSize, seperator);
        ((OutputStream)out).write(decoded);
        ((OutputStream)out).close();
        byte[] output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked base64 encode", (boolean)Arrays.equals(output, encoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base64OutputStream((OutputStream)byteOut, false);
        ((OutputStream)out).write(encoded);
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked base64 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base64OutputStream((OutputStream)out, false);
            out = new Base64OutputStream((OutputStream)out, true, chunkSize, seperator);
        }
        ((OutputStream)out).write(decoded);
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked base64 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] seperator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Object out = new Base64OutputStream((OutputStream)byteOut, true, chunkSize, seperator);
        for (byte element : decoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        byte[] output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte base64 encode", (boolean)Arrays.equals(output, encoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base64OutputStream((OutputStream)byteOut, false);
        for (byte element : encoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte base64 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base64OutputStream((OutputStream)byteOut, false);
        for (byte element : encoded) {
            ((OutputStream)out).write(element);
            ((OutputStream)out).flush();
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte flush() base64 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base64OutputStream((OutputStream)out, false);
            out = new Base64OutputStream((OutputStream)out, true, chunkSize, seperator);
        }
        for (byte element : decoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte base64 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
    }

    @Test
    public void testWriteOutOfBounds() throws Exception {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)bout);
        try {
            out.write(buf, -1, 1);
            Assert.fail((String)"Expected Base64OutputStream.write(buf, -1, 1) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, 1, -1);
            Assert.fail((String)"Expected Base64OutputStream.write(buf, 1, -1) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, buf.length + 1, 0);
            Assert.fail((String)"Expected Base64OutputStream.write(buf, buf.length + 1, 0) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, buf.length - 1, 2);
            Assert.fail((String)"Expected Base64OutputStream.write(buf, buf.length - 1, 2) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToNullCoverage() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)bout);
        try {
            out.write(null, 0, 0);
            Assert.fail((String)"Expcted Base64OutputStream.write(null) to throw a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            out.close();
        }
    }
}

