/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import junit.framework.Assert;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.codec.language.SoundexUtils;
import org.junit.Test;

public class SoundexTest
extends StringEncoderAbstractTest {
    @Override
    protected StringEncoder createStringEncoder() {
        return new Soundex();
    }

    public Soundex getSoundexEncoder() {
        return (Soundex)this.getStringEncoder();
    }

    @Test
    public void testB650() throws EncoderException {
        this.checkEncodingVariations("B650", new String[]{"BARHAM", "BARONE", "BARRON", "BERNA", "BIRNEY", "BIRNIE", "BOOROM", "BOREN", "BORN", "BOURN", "BOURNE", "BOWRON", "BRAIN", "BRAME", "BRANN", "BRAUN", "BREEN", "BRIEN", "BRIM", "BRIMM", "BRINN", "BRION", "BROOM", "BROOME", "BROWN", "BROWNE", "BRUEN", "BRUHN", "BRUIN", "BRUMM", "BRUN", "BRUNO", "BRYAN", "BURIAN", "BURN", "BURNEY", "BYRAM", "BYRNE", "BYRON", "BYRUM"});
    }

    @Test
    public void testBadCharacters() {
        Assert.assertEquals((String)"H452", (String)this.getSoundexEncoder().encode("HOL>MES"));
    }

    @Test
    public void testDifference() throws EncoderException {
        Assert.assertEquals((int)0, (int)this.getSoundexEncoder().difference(null, null));
        Assert.assertEquals((int)0, (int)this.getSoundexEncoder().difference("", ""));
        Assert.assertEquals((int)0, (int)this.getSoundexEncoder().difference(" ", " "));
        Assert.assertEquals((int)4, (int)this.getSoundexEncoder().difference("Smith", "Smythe"));
        Assert.assertEquals((int)2, (int)this.getSoundexEncoder().difference("Ann", "Andrew"));
        Assert.assertEquals((int)1, (int)this.getSoundexEncoder().difference("Margaret", "Andrew"));
        Assert.assertEquals((int)0, (int)this.getSoundexEncoder().difference("Janet", "Margaret"));
        Assert.assertEquals((int)4, (int)this.getSoundexEncoder().difference("Green", "Greene"));
        Assert.assertEquals((int)0, (int)this.getSoundexEncoder().difference("Blotchet-Halls", "Greene"));
        Assert.assertEquals((int)4, (int)this.getSoundexEncoder().difference("Smith", "Smythe"));
        Assert.assertEquals((int)4, (int)this.getSoundexEncoder().difference("Smithers", "Smythers"));
        Assert.assertEquals((int)2, (int)this.getSoundexEncoder().difference("Anothers", "Brothers"));
    }

    @Test
    public void testEncodeBasic() {
        Assert.assertEquals((String)"T235", (String)this.getSoundexEncoder().encode("testing"));
        Assert.assertEquals((String)"T000", (String)this.getSoundexEncoder().encode("The"));
        Assert.assertEquals((String)"Q200", (String)this.getSoundexEncoder().encode("quick"));
        Assert.assertEquals((String)"B650", (String)this.getSoundexEncoder().encode("brown"));
        Assert.assertEquals((String)"F200", (String)this.getSoundexEncoder().encode("fox"));
        Assert.assertEquals((String)"J513", (String)this.getSoundexEncoder().encode("jumped"));
        Assert.assertEquals((String)"O160", (String)this.getSoundexEncoder().encode("over"));
        Assert.assertEquals((String)"T000", (String)this.getSoundexEncoder().encode("the"));
        Assert.assertEquals((String)"L200", (String)this.getSoundexEncoder().encode("lazy"));
        Assert.assertEquals((String)"D200", (String)this.getSoundexEncoder().encode("dogs"));
    }

    @Test
    public void testEncodeBatch2() {
        Assert.assertEquals((String)"A462", (String)this.getSoundexEncoder().encode("Allricht"));
        Assert.assertEquals((String)"E166", (String)this.getSoundexEncoder().encode("Eberhard"));
        Assert.assertEquals((String)"E521", (String)this.getSoundexEncoder().encode("Engebrethson"));
        Assert.assertEquals((String)"H512", (String)this.getSoundexEncoder().encode("Heimbach"));
        Assert.assertEquals((String)"H524", (String)this.getSoundexEncoder().encode("Hanselmann"));
        Assert.assertEquals((String)"H431", (String)this.getSoundexEncoder().encode("Hildebrand"));
        Assert.assertEquals((String)"K152", (String)this.getSoundexEncoder().encode("Kavanagh"));
        Assert.assertEquals((String)"L530", (String)this.getSoundexEncoder().encode("Lind"));
        Assert.assertEquals((String)"L222", (String)this.getSoundexEncoder().encode("Lukaschowsky"));
        Assert.assertEquals((String)"M235", (String)this.getSoundexEncoder().encode("McDonnell"));
        Assert.assertEquals((String)"M200", (String)this.getSoundexEncoder().encode("McGee"));
        Assert.assertEquals((String)"O155", (String)this.getSoundexEncoder().encode("Opnian"));
        Assert.assertEquals((String)"O155", (String)this.getSoundexEncoder().encode("Oppenheimer"));
        Assert.assertEquals((String)"R355", (String)this.getSoundexEncoder().encode("Riedemanas"));
        Assert.assertEquals((String)"Z300", (String)this.getSoundexEncoder().encode("Zita"));
        Assert.assertEquals((String)"Z325", (String)this.getSoundexEncoder().encode("Zitzmeinn"));
    }

    @Test
    public void testEncodeBatch3() {
        Assert.assertEquals((String)"W252", (String)this.getSoundexEncoder().encode("Washington"));
        Assert.assertEquals((String)"L000", (String)this.getSoundexEncoder().encode("Lee"));
        Assert.assertEquals((String)"G362", (String)this.getSoundexEncoder().encode("Gutierrez"));
        Assert.assertEquals((String)"P236", (String)this.getSoundexEncoder().encode("Pfister"));
        Assert.assertEquals((String)"J250", (String)this.getSoundexEncoder().encode("Jackson"));
        Assert.assertEquals((String)"T522", (String)this.getSoundexEncoder().encode("Tymczak"));
        Assert.assertEquals((String)"V532", (String)this.getSoundexEncoder().encode("VanDeusen"));
    }

    @Test
    public void testEncodeBatch4() {
        Assert.assertEquals((String)"H452", (String)this.getSoundexEncoder().encode("HOLMES"));
        Assert.assertEquals((String)"A355", (String)this.getSoundexEncoder().encode("ADOMOMI"));
        Assert.assertEquals((String)"V536", (String)this.getSoundexEncoder().encode("VONDERLEHR"));
        Assert.assertEquals((String)"B400", (String)this.getSoundexEncoder().encode("BALL"));
        Assert.assertEquals((String)"S000", (String)this.getSoundexEncoder().encode("SHAW"));
        Assert.assertEquals((String)"J250", (String)this.getSoundexEncoder().encode("JACKSON"));
        Assert.assertEquals((String)"S545", (String)this.getSoundexEncoder().encode("SCANLON"));
        Assert.assertEquals((String)"S532", (String)this.getSoundexEncoder().encode("SAINTJOHN"));
    }

    @Test
    public void testEncodeIgnoreApostrophes() throws EncoderException {
        this.checkEncodingVariations("O165", new String[]{"OBrien", "'OBrien", "O'Brien", "OB'rien", "OBr'ien", "OBri'en", "OBrie'n", "OBrien'"});
    }

    @Test
    public void testEncodeIgnoreHyphens() throws EncoderException {
        this.checkEncodingVariations("K525", new String[]{"KINGSMITH", "-KINGSMITH", "K-INGSMITH", "KI-NGSMITH", "KIN-GSMITH", "KING-SMITH", "KINGS-MITH", "KINGSM-ITH", "KINGSMI-TH", "KINGSMIT-H", "KINGSMITH-"});
    }

    @Test
    public void testEncodeIgnoreTrimmable() {
        Assert.assertEquals((String)"W252", (String)this.getSoundexEncoder().encode(" \t\n\r Washington \t\n\r "));
    }

    @Test
    public void testHWRuleEx1() {
        Assert.assertEquals((String)"A261", (String)this.getSoundexEncoder().encode("Ashcraft"));
    }

    @Test
    public void testHWRuleEx2() {
        Assert.assertEquals((String)"B312", (String)this.getSoundexEncoder().encode("BOOTHDAVIS"));
        Assert.assertEquals((String)"B312", (String)this.getSoundexEncoder().encode("BOOTH-DAVIS"));
    }

    @Test
    public void testHWRuleEx3() throws EncoderException {
        Assert.assertEquals((String)"S460", (String)this.getSoundexEncoder().encode("Sgler"));
        Assert.assertEquals((String)"S460", (String)this.getSoundexEncoder().encode("Swhgler"));
        this.checkEncodingVariations("S460", new String[]{"SAILOR", "SALYER", "SAYLOR", "SCHALLER", "SCHELLER", "SCHILLER", "SCHOOLER", "SCHULER", "SCHUYLER", "SEILER", "SEYLER", "SHOLAR", "SHULER", "SILAR", "SILER", "SILLER"});
    }

    @Test
    public void testMsSqlServer1() {
        Assert.assertEquals((String)"S530", (String)this.getSoundexEncoder().encode("Smith"));
        Assert.assertEquals((String)"S530", (String)this.getSoundexEncoder().encode("Smythe"));
    }

    @Test
    public void testMsSqlServer2() throws EncoderException {
        this.checkEncodingVariations("E625", new String[]{"Erickson", "Erickson", "Erikson", "Ericson", "Ericksen", "Ericsen"});
    }

    @Test
    public void testMsSqlServer3() {
        Assert.assertEquals((String)"A500", (String)this.getSoundexEncoder().encode("Ann"));
        Assert.assertEquals((String)"A536", (String)this.getSoundexEncoder().encode("Andrew"));
        Assert.assertEquals((String)"J530", (String)this.getSoundexEncoder().encode("Janet"));
        Assert.assertEquals((String)"M626", (String)this.getSoundexEncoder().encode("Margaret"));
        Assert.assertEquals((String)"S315", (String)this.getSoundexEncoder().encode("Steven"));
        Assert.assertEquals((String)"M240", (String)this.getSoundexEncoder().encode("Michael"));
        Assert.assertEquals((String)"R163", (String)this.getSoundexEncoder().encode("Robert"));
        Assert.assertEquals((String)"L600", (String)this.getSoundexEncoder().encode("Laura"));
        Assert.assertEquals((String)"A500", (String)this.getSoundexEncoder().encode("Anne"));
    }

    @Test
    public void testNewInstance() {
        Assert.assertEquals((String)"W452", (String)new Soundex().soundex("Williams"));
    }

    @Test
    public void testNewInstance2() {
        Assert.assertEquals((String)"W452", (String)new Soundex("01230120022455012623010202".toCharArray()).soundex("Williams"));
    }

    @Test
    public void testNewInstance3() {
        Assert.assertEquals((String)"W452", (String)new Soundex("01230120022455012623010202").soundex("Williams"));
    }

    @Test
    public void testSoundexUtilsConstructable() {
        new SoundexUtils();
    }

    @Test
    public void testSoundexUtilsNullBehaviour() {
        Assert.assertEquals(null, (String)SoundexUtils.clean(null));
        Assert.assertEquals((String)"", (String)SoundexUtils.clean((String)""));
        Assert.assertEquals((int)0, (int)SoundexUtils.differenceEncoded(null, (String)""));
        Assert.assertEquals((int)0, (int)SoundexUtils.differenceEncoded((String)"", null));
    }

    @Test
    public void testUsEnglishStatic() {
        Assert.assertEquals((String)"W452", (String)Soundex.US_ENGLISH.soundex("Williams"));
    }

    @Test
    public void testUsMappingEWithAcute() {
        Assert.assertEquals((String)"E000", (String)this.getSoundexEncoder().encode("e"));
        if (Character.isLetter('\u00e9')) {
            try {
                Assert.assertEquals((String)"\u00c9000", (String)this.getSoundexEncoder().encode("\u00e9"));
                Assert.fail((String)"Expected IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            Assert.assertEquals((String)"", (String)this.getSoundexEncoder().encode("\u00e9"));
        }
    }

    @Test
    public void testUsMappingOWithDiaeresis() {
        Assert.assertEquals((String)"O000", (String)this.getSoundexEncoder().encode("o"));
        if (Character.isLetter('\u00f6')) {
            try {
                Assert.assertEquals((String)"\u00d6000", (String)this.getSoundexEncoder().encode("\u00f6"));
                Assert.fail((String)"Expected IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            Assert.assertEquals((String)"", (String)this.getSoundexEncoder().encode("\u00f6"));
        }
    }
}

