/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.codec.language.SoundexUtils;
import org.junit.Assert;
import org.junit.Test;

public class SoundexTest
extends StringEncoderAbstractTest<Soundex> {
    @Override
    protected Soundex createStringEncoder() {
        return new Soundex();
    }

    @Test
    public void testB650() throws EncoderException {
        this.checkEncodingVariations("B650", new String[]{"BARHAM", "BARONE", "BARRON", "BERNA", "BIRNEY", "BIRNIE", "BOOROM", "BOREN", "BORN", "BOURN", "BOURNE", "BOWRON", "BRAIN", "BRAME", "BRANN", "BRAUN", "BREEN", "BRIEN", "BRIM", "BRIMM", "BRINN", "BRION", "BROOM", "BROOME", "BROWN", "BROWNE", "BRUEN", "BRUHN", "BRUIN", "BRUMM", "BRUN", "BRUNO", "BRYAN", "BURIAN", "BURN", "BURNEY", "BYRAM", "BYRNE", "BYRON", "BYRUM"});
    }

    @Test
    public void testBadCharacters() {
        Assert.assertEquals((Object)"H452", (Object)((Soundex)this.getStringEncoder()).encode("HOL>MES"));
    }

    @Test
    public void testDifference() throws EncoderException {
        Assert.assertEquals((long)0L, (long)((Soundex)this.getStringEncoder()).difference(null, null));
        Assert.assertEquals((long)0L, (long)((Soundex)this.getStringEncoder()).difference("", ""));
        Assert.assertEquals((long)0L, (long)((Soundex)this.getStringEncoder()).difference(" ", " "));
        Assert.assertEquals((long)4L, (long)((Soundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assert.assertEquals((long)2L, (long)((Soundex)this.getStringEncoder()).difference("Ann", "Andrew"));
        Assert.assertEquals((long)1L, (long)((Soundex)this.getStringEncoder()).difference("Margaret", "Andrew"));
        Assert.assertEquals((long)0L, (long)((Soundex)this.getStringEncoder()).difference("Janet", "Margaret"));
        Assert.assertEquals((long)4L, (long)((Soundex)this.getStringEncoder()).difference("Green", "Greene"));
        Assert.assertEquals((long)0L, (long)((Soundex)this.getStringEncoder()).difference("Blotchet-Halls", "Greene"));
        Assert.assertEquals((long)4L, (long)((Soundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assert.assertEquals((long)4L, (long)((Soundex)this.getStringEncoder()).difference("Smithers", "Smythers"));
        Assert.assertEquals((long)2L, (long)((Soundex)this.getStringEncoder()).difference("Anothers", "Brothers"));
    }

    @Test
    public void testEncodeBasic() {
        Assert.assertEquals((Object)"T235", (Object)((Soundex)this.getStringEncoder()).encode("testing"));
        Assert.assertEquals((Object)"T000", (Object)((Soundex)this.getStringEncoder()).encode("The"));
        Assert.assertEquals((Object)"Q200", (Object)((Soundex)this.getStringEncoder()).encode("quick"));
        Assert.assertEquals((Object)"B650", (Object)((Soundex)this.getStringEncoder()).encode("brown"));
        Assert.assertEquals((Object)"F200", (Object)((Soundex)this.getStringEncoder()).encode("fox"));
        Assert.assertEquals((Object)"J513", (Object)((Soundex)this.getStringEncoder()).encode("jumped"));
        Assert.assertEquals((Object)"O160", (Object)((Soundex)this.getStringEncoder()).encode("over"));
        Assert.assertEquals((Object)"T000", (Object)((Soundex)this.getStringEncoder()).encode("the"));
        Assert.assertEquals((Object)"L200", (Object)((Soundex)this.getStringEncoder()).encode("lazy"));
        Assert.assertEquals((Object)"D200", (Object)((Soundex)this.getStringEncoder()).encode("dogs"));
    }

    @Test
    public void testEncodeBatch2() {
        Assert.assertEquals((Object)"A462", (Object)((Soundex)this.getStringEncoder()).encode("Allricht"));
        Assert.assertEquals((Object)"E166", (Object)((Soundex)this.getStringEncoder()).encode("Eberhard"));
        Assert.assertEquals((Object)"E521", (Object)((Soundex)this.getStringEncoder()).encode("Engebrethson"));
        Assert.assertEquals((Object)"H512", (Object)((Soundex)this.getStringEncoder()).encode("Heimbach"));
        Assert.assertEquals((Object)"H524", (Object)((Soundex)this.getStringEncoder()).encode("Hanselmann"));
        Assert.assertEquals((Object)"H431", (Object)((Soundex)this.getStringEncoder()).encode("Hildebrand"));
        Assert.assertEquals((Object)"K152", (Object)((Soundex)this.getStringEncoder()).encode("Kavanagh"));
        Assert.assertEquals((Object)"L530", (Object)((Soundex)this.getStringEncoder()).encode("Lind"));
        Assert.assertEquals((Object)"L222", (Object)((Soundex)this.getStringEncoder()).encode("Lukaschowsky"));
        Assert.assertEquals((Object)"M235", (Object)((Soundex)this.getStringEncoder()).encode("McDonnell"));
        Assert.assertEquals((Object)"M200", (Object)((Soundex)this.getStringEncoder()).encode("McGee"));
        Assert.assertEquals((Object)"O155", (Object)((Soundex)this.getStringEncoder()).encode("Opnian"));
        Assert.assertEquals((Object)"O155", (Object)((Soundex)this.getStringEncoder()).encode("Oppenheimer"));
        Assert.assertEquals((Object)"R355", (Object)((Soundex)this.getStringEncoder()).encode("Riedemanas"));
        Assert.assertEquals((Object)"Z300", (Object)((Soundex)this.getStringEncoder()).encode("Zita"));
        Assert.assertEquals((Object)"Z325", (Object)((Soundex)this.getStringEncoder()).encode("Zitzmeinn"));
    }

    @Test
    public void testEncodeBatch3() {
        Assert.assertEquals((Object)"W252", (Object)((Soundex)this.getStringEncoder()).encode("Washington"));
        Assert.assertEquals((Object)"L000", (Object)((Soundex)this.getStringEncoder()).encode("Lee"));
        Assert.assertEquals((Object)"G362", (Object)((Soundex)this.getStringEncoder()).encode("Gutierrez"));
        Assert.assertEquals((Object)"P236", (Object)((Soundex)this.getStringEncoder()).encode("Pfister"));
        Assert.assertEquals((Object)"J250", (Object)((Soundex)this.getStringEncoder()).encode("Jackson"));
        Assert.assertEquals((Object)"T522", (Object)((Soundex)this.getStringEncoder()).encode("Tymczak"));
        Assert.assertEquals((Object)"V532", (Object)((Soundex)this.getStringEncoder()).encode("VanDeusen"));
    }

    @Test
    public void testEncodeBatch4() {
        Assert.assertEquals((Object)"H452", (Object)((Soundex)this.getStringEncoder()).encode("HOLMES"));
        Assert.assertEquals((Object)"A355", (Object)((Soundex)this.getStringEncoder()).encode("ADOMOMI"));
        Assert.assertEquals((Object)"V536", (Object)((Soundex)this.getStringEncoder()).encode("VONDERLEHR"));
        Assert.assertEquals((Object)"B400", (Object)((Soundex)this.getStringEncoder()).encode("BALL"));
        Assert.assertEquals((Object)"S000", (Object)((Soundex)this.getStringEncoder()).encode("SHAW"));
        Assert.assertEquals((Object)"J250", (Object)((Soundex)this.getStringEncoder()).encode("JACKSON"));
        Assert.assertEquals((Object)"S545", (Object)((Soundex)this.getStringEncoder()).encode("SCANLON"));
        Assert.assertEquals((Object)"S532", (Object)((Soundex)this.getStringEncoder()).encode("SAINTJOHN"));
    }

    @Test
    public void testEncodeIgnoreApostrophes() throws EncoderException {
        this.checkEncodingVariations("O165", new String[]{"OBrien", "'OBrien", "O'Brien", "OB'rien", "OBr'ien", "OBri'en", "OBrie'n", "OBrien'"});
    }

    @Test
    public void testEncodeIgnoreHyphens() throws EncoderException {
        this.checkEncodingVariations("K525", new String[]{"KINGSMITH", "-KINGSMITH", "K-INGSMITH", "KI-NGSMITH", "KIN-GSMITH", "KING-SMITH", "KINGS-MITH", "KINGSM-ITH", "KINGSMI-TH", "KINGSMIT-H", "KINGSMITH-"});
    }

    @Test
    public void testEncodeIgnoreTrimmable() {
        Assert.assertEquals((Object)"W252", (Object)((Soundex)this.getStringEncoder()).encode(" \t\n\r Washington \t\n\r "));
    }

    @Test
    public void testHWRuleEx1() {
        Assert.assertEquals((Object)"A261", (Object)((Soundex)this.getStringEncoder()).encode("Ashcraft"));
    }

    @Test
    public void testHWRuleEx2() {
        Assert.assertEquals((Object)"B312", (Object)((Soundex)this.getStringEncoder()).encode("BOOTHDAVIS"));
        Assert.assertEquals((Object)"B312", (Object)((Soundex)this.getStringEncoder()).encode("BOOTH-DAVIS"));
    }

    @Test
    public void testHWRuleEx3() throws EncoderException {
        Assert.assertEquals((Object)"S460", (Object)((Soundex)this.getStringEncoder()).encode("Sgler"));
        Assert.assertEquals((Object)"S460", (Object)((Soundex)this.getStringEncoder()).encode("Swhgler"));
        this.checkEncodingVariations("S460", new String[]{"SAILOR", "SALYER", "SAYLOR", "SCHALLER", "SCHELLER", "SCHILLER", "SCHOOLER", "SCHULER", "SCHUYLER", "SEILER", "SEYLER", "SHOLAR", "SHULER", "SILAR", "SILER", "SILLER"});
    }

    @Test
    public void testMsSqlServer1() {
        Assert.assertEquals((Object)"S530", (Object)((Soundex)this.getStringEncoder()).encode("Smith"));
        Assert.assertEquals((Object)"S530", (Object)((Soundex)this.getStringEncoder()).encode("Smythe"));
    }

    @Test
    public void testMsSqlServer2() throws EncoderException {
        this.checkEncodingVariations("E625", new String[]{"Erickson", "Erickson", "Erikson", "Ericson", "Ericksen", "Ericsen"});
    }

    @Test
    public void testMsSqlServer3() {
        Assert.assertEquals((Object)"A500", (Object)((Soundex)this.getStringEncoder()).encode("Ann"));
        Assert.assertEquals((Object)"A536", (Object)((Soundex)this.getStringEncoder()).encode("Andrew"));
        Assert.assertEquals((Object)"J530", (Object)((Soundex)this.getStringEncoder()).encode("Janet"));
        Assert.assertEquals((Object)"M626", (Object)((Soundex)this.getStringEncoder()).encode("Margaret"));
        Assert.assertEquals((Object)"S315", (Object)((Soundex)this.getStringEncoder()).encode("Steven"));
        Assert.assertEquals((Object)"M240", (Object)((Soundex)this.getStringEncoder()).encode("Michael"));
        Assert.assertEquals((Object)"R163", (Object)((Soundex)this.getStringEncoder()).encode("Robert"));
        Assert.assertEquals((Object)"L600", (Object)((Soundex)this.getStringEncoder()).encode("Laura"));
        Assert.assertEquals((Object)"A500", (Object)((Soundex)this.getStringEncoder()).encode("Anne"));
    }

    @Test
    public void testNewInstance() {
        Assert.assertEquals((Object)"W452", (Object)new Soundex().soundex("Williams"));
    }

    @Test
    public void testNewInstance2() {
        Assert.assertEquals((Object)"W452", (Object)new Soundex("01230120022455012623010202".toCharArray()).soundex("Williams"));
    }

    @Test
    public void testNewInstance3() {
        Assert.assertEquals((Object)"W452", (Object)new Soundex("01230120022455012623010202").soundex("Williams"));
    }

    @Test
    public void testSoundexUtilsConstructable() {
        new SoundexUtils();
    }

    @Test
    public void testSoundexUtilsNullBehaviour() {
        Assert.assertEquals(null, (Object)SoundexUtils.clean(null));
        Assert.assertEquals((Object)"", (Object)SoundexUtils.clean((String)""));
        Assert.assertEquals((long)0L, (long)SoundexUtils.differenceEncoded(null, (String)""));
        Assert.assertEquals((long)0L, (long)SoundexUtils.differenceEncoded((String)"", null));
    }

    @Test
    public void testUsEnglishStatic() {
        Assert.assertEquals((Object)"W452", (Object)Soundex.US_ENGLISH.soundex("Williams"));
    }

    @Test
    public void testUsMappingEWithAcute() {
        Assert.assertEquals((Object)"E000", (Object)((Soundex)this.getStringEncoder()).encode("e"));
        if (Character.isLetter('\u00e9')) {
            try {
                Assert.assertEquals((Object)"\u00c9000", (Object)((Soundex)this.getStringEncoder()).encode("\u00e9"));
                Assert.fail((String)"Expected IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            Assert.assertEquals((Object)"", (Object)((Soundex)this.getStringEncoder()).encode("\u00e9"));
        }
    }

    @Test
    public void testUsMappingOWithDiaeresis() {
        Assert.assertEquals((Object)"O000", (Object)((Soundex)this.getStringEncoder()).encode("o"));
        if (Character.isLetter('\u00f6')) {
            try {
                Assert.assertEquals((Object)"\u00d6000", (Object)((Soundex)this.getStringEncoder()).encode("\u00f6"));
                Assert.fail((String)"Expected IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            Assert.assertEquals((Object)"", (Object)((Soundex)this.getStringEncoder()).encode("\u00f6"));
        }
    }
}

