/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.NonStringTestHolder;

public abstract class BaseNonStringProperties
extends TestCase {
    protected NonStringTestHolder nonStringTestHolder = new NonStringTestHolder();
    public Configuration conf = null;

    public abstract void setUp() throws Exception;

    public BaseNonStringProperties(String s) throws Exception {
        super(s);
    }

    public void testBoolean() throws Exception {
        this.nonStringTestHolder.testBoolean();
    }

    public void testBooleanDefaultValue() throws Exception {
        this.nonStringTestHolder.testBooleanDefaultValue();
    }

    public void testBooleanArrayValue() throws Exception {
        boolean booleanValue = this.conf.getBoolean("test.boolean.array");
        Assert.assertEquals((boolean)false, (boolean)booleanValue);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.boolean.array").size());
    }

    public void testByte() throws Exception {
        this.nonStringTestHolder.testByte();
    }

    public void testByteArrayValue() throws Exception {
        byte testValue = 20;
        byte byteValue = this.conf.getByte("test.byte.array");
        Assert.assertEquals((byte)testValue, (byte)byteValue);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.byte.array").size());
    }

    public void testDouble() throws Exception {
        this.nonStringTestHolder.testDouble();
    }

    public void testDoubleDefaultValue() throws Exception {
        this.nonStringTestHolder.testDoubleDefaultValue();
    }

    public void testDoubleArrayValue() throws Exception {
        double testValue = 20.35;
        double doubleValue = this.conf.getDouble("test.double.array");
        Assert.assertEquals((double)testValue, (double)doubleValue, (double)0.01);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.double.array").size());
    }

    public void testFloat() throws Exception {
        this.nonStringTestHolder.testFloat();
    }

    public void testFloatDefaultValue() throws Exception {
        this.nonStringTestHolder.testFloatDefaultValue();
    }

    public void testFloatArrayValue() throws Exception {
        float testValue = 30.35f;
        float floatValue = this.conf.getFloat("test.float.array");
        Assert.assertEquals((double)testValue, (double)floatValue, (double)0.01);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.float.array").size());
    }

    public void testInteger() throws Exception {
        this.nonStringTestHolder.testInteger();
    }

    public void testIntegerDefaultValue() throws Exception {
        this.nonStringTestHolder.testIntegerDefaultValue();
    }

    public void testIntegerArrayValue() throws Exception {
        int intValue = this.conf.getInt("test.integer.array");
        Assert.assertEquals((int)20, (int)intValue);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.integer.array").size());
    }

    public void testLong() throws Exception {
        this.nonStringTestHolder.testLong();
    }

    public void testLongDefaultValue() throws Exception {
        this.nonStringTestHolder.testLongDefaultValue();
    }

    public void testLongArrayValue() throws Exception {
        long longValue = this.conf.getLong("test.long.array");
        Assert.assertEquals((long)2000000L, (long)longValue);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.long.array").size());
    }

    public void testShort() throws Exception {
        this.nonStringTestHolder.testShort();
    }

    public void testShortDefaultValue() throws Exception {
        this.nonStringTestHolder.testShortDefaultValue();
    }

    public void testShortArrayValue() throws Exception {
        short shortValue = this.conf.getShort("test.short.array");
        Assert.assertEquals((int)2, (int)shortValue);
        Assert.assertEquals((int)2, (int)this.conf.getVector("test.short.array").size());
    }

    public void testVectorMissing() throws Exception {
        this.nonStringTestHolder.testVectorMissing();
    }

    public void testSubset() throws Exception {
        this.nonStringTestHolder.testSubset();
    }

    public void testIsEmpty() throws Exception {
        this.nonStringTestHolder.testIsEmpty();
    }
}

