/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration.BasePropertiesConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class ClassPropertiesConfiguration
extends BasePropertiesConfiguration
implements Configuration {
    private Class baseClass = null;
    private ClassLoader classLoader = null;

    public ClassPropertiesConfiguration(Class baseClass, String resource) throws IOException {
        this.baseClass = baseClass;
        this.classLoader = baseClass.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : baseClass.getClassLoader();
        this.setIncludesAllowed(true);
        this.load(this.getPropertyStream(resource));
    }

    public ClassPropertiesConfiguration(Class baseClass, String resource, Configuration defaults) throws IOException {
        this(baseClass, resource);
        this.defaults = defaults;
    }

    public ClassPropertiesConfiguration(Class baseClass, String resource, String defaultFile) throws IOException {
        this(baseClass, resource);
        if (StringUtils.isNotEmpty((String)defaultFile)) {
            this.defaults = new ClassPropertiesConfiguration(baseClass, defaultFile);
        }
    }

    public InputStream getPropertyStream(String resourceName) throws IOException {
        InputStream resource = null;
        if (resourceName.startsWith("/")) {
            resource = this.classLoader.getResourceAsStream(resourceName);
        } else {
            StringBuffer classPath = new StringBuffer();
            classPath.append(this.baseClass.getPackage().getName().replace('.', '/'));
            classPath.append("/");
            if (resourceName.startsWith("./")) {
                classPath.append(resourceName.substring(2));
            } else {
                classPath.append(resourceName);
            }
            resource = this.classLoader.getResourceAsStream(classPath.toString());
        }
        if (resource == null) {
            throw new FileNotFoundException("Could not open Resource " + resourceName);
        }
        return resource;
    }
}

