/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIConfiguration
extends BaseConfiguration
implements Configuration {
    private static Log log;
    private String prefix;
    private Context envCtx;
    private List clearedProperties = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.JNDIConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void addProperty(String key, Object token) {
        throw new Error("This operation is not supported");
    }

    private void recursiveGetKeys(List keys, NamingEnumeration namingEnumeration, String key) throws NamingException {
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.next();
            StringBuffer newKey = new StringBuffer();
            newKey.append(key);
            if (newKey.length() > 0) {
                newKey.append(".");
            }
            newKey.append(binding.getName());
            if (binding.getObject() instanceof Context) {
                Context c = (Context)binding.getObject();
                NamingEnumeration<Binding> enum2 = c.listBindings("");
                this.recursiveGetKeys(keys, enum2, newKey.toString());
                continue;
            }
            if (keys.contains(newKey.toString())) continue;
            keys.add(newKey.toString());
        }
    }

    public Iterator getKeys() {
        return this.getKeys("");
    }

    public Iterator getKeys(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            String[] splitKeys = StringUtils.split((String)key, (String)".");
            int i = 0;
            while (i < splitKeys.length) {
                keys.add(splitKeys[i]);
                ++i;
            }
            Context context = null;
            context = keys.size() == 0 ? this.getContext() : this.getStartingContextPoint(keys, this.getContext().listBindings(""));
            if (context != null) {
                NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
                this.recursiveGetKeys(keys, namingEnumeration, key);
            }
        }
        catch (NamingException ne) {
            log.warn((Object)ne);
        }
        return keys.iterator();
    }

    private Context getStartingContextPoint(List keys, NamingEnumeration namingEnumeration) throws NamingException {
        String keyToSearchFor = (String)keys.get(0);
        log.debug((Object)("Key to search for is " + keyToSearchFor));
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.next();
            log.debug((Object)("Binding for name: " + binding.getName() + ", object:" + binding.getObject() + ", class:" + binding.getClassName()));
            if (!(binding.getObject() instanceof Context) || !binding.getName().equals(keyToSearchFor)) continue;
            keys.remove(0);
            Context c = (Context)binding.getObject();
            if (keys.size() > 0) {
                return this.getStartingContextPoint(keys, c.listBindings(""));
            }
            return c;
        }
        return null;
    }

    public Properties getProperties(String key) {
        throw new Error("This operation is not supported");
    }

    public boolean isEmpty() {
        try {
            NamingEnumeration<Binding> namingEnumeration = this.getContext().listBindings("");
            return !namingEnumeration.hasMore();
        }
        catch (NamingException ne) {
            log.warn((Object)ne);
            return true;
        }
    }

    public Object getProperty(String key) {
        throw new Error("This operation is not supported");
    }

    public void setProperty(String key, Object value) {
        throw new Error("This operation is not supported");
    }

    public void clearProperty(String key) {
        if (!this.clearedProperties.contains(key)) {
            this.clearedProperties.add(key);
        }
    }

    public boolean containsKey(String key) {
        if (this.clearedProperties.contains(key)) {
            return false;
        }
        key = StringUtils.replace((String)key, (String)".", (String)"/");
        try {
            Object object = this.getContext().lookup(key);
            return true;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    public Configuration subset(String prefix) {
        BaseConfiguration c = new BaseConfiguration();
        Iterator keys = this.getKeys();
        boolean validSubset = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            if (!validSubset) {
                validSubset = true;
            }
            String newKey = null;
            newKey = ((String)key).length() == prefix.length() ? prefix : ((String)key).substring(prefix.length() + 1);
            Object value = this.getValueFromJNDI(key.toString());
            if (value instanceof String) {
                c.addPropertyDirect(newKey, this.interpolate((String)value));
                continue;
            }
            c.addPropertyDirect(newKey, value);
        }
        if (validSubset) {
            return c;
        }
        return null;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = this.testBoolean((String)value);
            Boolean b = new Boolean(s);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Boolean object");
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b = new Byte((String)value);
            return b;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Byte object");
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d = new Double((String)value);
            return d;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Double object");
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f = new Float((String)value);
            return f;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Float object");
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            return i;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Integer object");
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l = new Long((String)value);
            return l;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Long object");
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.getValueFromJNDI(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            return s;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a Short object");
    }

    public String getString(String key, String defaultValue) {
        try {
            Object o = this.getValueFromJNDI(key);
            if (o == null) {
                return defaultValue;
            }
            return (String)o;
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(String key) {
        void var3_3;
        String[] tokens;
        Object value = this.getValueFromJNDI(key);
        if (value instanceof String) {
            tokens = new String[]{this.interpolate((String)value)};
        } else if (value instanceof BaseConfiguration.Container) {
            tokens = new String[((BaseConfiguration.Container)value).size()];
            int i = 0;
            while (i < tokens.length) {
                tokens[i] = this.interpolate((String)((BaseConfiguration.Container)value).get(i));
                ++i;
            }
        } else if (value == null) {
            tokens = new String[]{};
        } else {
            throw new ClassCastException(String.valueOf('\'') + key + "' doesn't map to a String/Vector object");
        }
        return var3_3;
    }

    public Vector getVector(String key, Vector defaultValue) {
        try {
            Object value = this.getValueFromJNDI(key);
            if (value != null) {
                Vector<String> v = new Vector<String>(1);
                v.add(value.toString());
                return v;
            }
            if (defaultValue == null) {
                defaultValue = new Vector();
            }
            return defaultValue;
        }
        catch (NoSuchElementException nsse) {
            return defaultValue;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private Object getValueFromJNDI(String key) {
        if (this.clearedProperties.contains(key)) {
            return null;
        }
        try {
            key = StringUtils.replace((String)key, (String)".", (String)"/");
            return this.getContext().lookup(key);
        }
        catch (NoSuchElementException nsse) {
            return null;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    private Context getContext() throws NamingException {
        if (this.envCtx == null) {
            InitialContext initCtx = new InitialContext();
            this.envCtx = (Context)initCtx.lookup(this.getPrefix());
        }
        return this.envCtx;
    }
}

