/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.BasePropertiesConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DOM4JConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class TestCompositeConfiguration
extends TestCase {
    protected BasePropertiesConfiguration conf1;
    protected BasePropertiesConfiguration conf2;
    protected DOM4JConfiguration dom4jConf;
    protected CompositeConfiguration cc;
    private String testProperties = new File("conf/test.properties").getAbsolutePath();
    private String testProperties2 = new File("conf/test2.properties").getAbsolutePath();
    private String testPropertiesXML = new File("conf/test.xml").getAbsolutePath();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TestCompositeConfiguration(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        this.cc = new CompositeConfiguration();
        this.conf1 = new PropertiesConfiguration(this.testProperties);
        this.conf2 = new PropertiesConfiguration(this.testProperties2);
        this.dom4jConf = new DOM4JConfiguration(new File(this.testPropertiesXML));
    }

    public void testAddRemoveConfigurations() throws Exception {
        this.cc.addConfiguration(this.conf1);
        Assert.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration(this.conf1);
        Assert.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration(this.conf2);
        Assert.assertEquals((int)3, (int)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration(this.conf1);
        Assert.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assert.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    public void testGetProperty() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.conf2);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (Object)"packagea", (Object)this.cc.getString("packages"));
        this.cc.clear();
        this.cc.addConfiguration(this.conf2);
        this.cc.addConfiguration(this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (Object)"override.packages", (Object)this.cc.getString("packages"));
    }

    public void testGetPropertyMissing() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.conf2);
        Assert.assertNull((Object)this.cc.getString("bogus.property"));
        Assert.assertTrue((String)"Should be false", (!this.cc.getBoolean("test.missing.boolean", false) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be true", (boolean)this.cc.getBoolean("test.missing.boolean.true", true));
    }

    public void testMultipleTypesOfConfigs() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (int)1, (int)this.cc.getInt("test.short"));
        this.cc.clear();
        this.cc.addConfiguration(this.dom4jConf);
        this.cc.addConfiguration(this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from dom4j", (int)8, (int)this.cc.getInt("test.short"));
    }

    public void testPropertyExistsInOnlyOneConfig() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Assert.assertEquals((Object)"value", (Object)this.cc.getString("element"));
    }

    public void testDefaultValueWhenKeyMissing() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Assert.assertEquals((Object)"default", (Object)this.cc.getString("bogus", "default"));
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
    }

    public void testGettingConfiguration() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, this.cc.getConfiguration(1).getClass());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.apache.commons.configuration.DOM4JConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz2, this.cc.getConfiguration(2).getClass());
    }

    public void testClearingProperty() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        this.cc.clearProperty("test.short");
        Assert.assertTrue((String)"Make sure test.short is gone!", (!this.cc.containsKey("test.short") ? 1 : 0) != 0);
    }

    public void testAddingProperty() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        this.cc.addProperty("test.short", "88");
        Assert.assertEquals((String)"Make sure test.short is overridden!", (Object)"88", (Object)this.cc.getString("test.short"));
    }

    public void testSettingMissingProperty() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        this.cc.setProperty("my.new.property", "supernew");
        Assert.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }

    public void testGettingSubset() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Configuration subset = null;
        subset = this.cc.subset("test.short");
        Assert.assertNotNull((Object)subset);
        Assert.assertTrue((String)"Shouldn't be empty", (!subset.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overridesany later add configs subset", (Object)"1", (Object)subset.getString("test.short"));
        this.cc.setProperty("test.short", "43");
        subset = this.cc.subset("test.short");
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overridesany later add configs subset", (Object)"43", (Object)subset.getString("test.short"));
    }

    public void testVector() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        Vector packages = this.cc.getVector("packages");
        Assert.assertEquals((int)3, (int)packages.size());
        Vector<String> defaultVector = new Vector<String>();
        defaultVector.add("1");
        defaultVector.add("2");
        packages = this.cc.getVector("packages.which.dont.exist", defaultVector);
        Assert.assertEquals((int)2, (int)packages.size());
    }

    public void testStringArray() throws Exception {
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.dom4jConf);
        String[] packages = this.cc.getStringArray("packages");
        Assert.assertEquals((int)3, (int)packages.length);
        packages = this.cc.getStringArray("packages.which.dont.exist");
        Assert.assertEquals((int)0, (int)packages.length);
    }

    public void testGetKeysPreservesOrder() throws Exception {
        this.cc.addConfiguration(this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys();
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys();
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((int)orderedList.size(), (int)iteratedList.size());
        int i = 0;
        while (i < orderedList.size()) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
            ++i;
        }
    }

    public void testGetKeys2PreservesOrder() throws Exception {
        this.cc.addConfiguration(this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys("test");
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys("test");
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((int)orderedList.size(), (int)iteratedList.size());
        int i = 0;
        while (i < orderedList.size()) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
            ++i;
        }
    }
}

