/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestConfigurationFactory
extends TestCase {
    private static Log log;
    private File digesterRules = new File("conf/digesterRules.xml");
    private File testDigesterFile = new File("conf/testDigesterConfiguration.xml");
    private File testDigesterFileReverseOrder = new File("conf/testDigesterConfigurationReverseOrder.xml");
    private File testDigesterFileNamespaceAware = new File("conf/testDigesterConfigurationNamespaceAware.xml");
    private File testDigesterFileBasePath = new File("conf/testDigesterConfigurationBasePath.xml");
    private String testBasePath = new File("conf").getAbsolutePath();
    private Configuration configuration;
    private CompositeConfiguration compositeConfiguration;
    private ConfigurationFactory configurationFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.TestConfigurationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public TestConfigurationFactory(String s) throws Exception {
        super(s);
    }

    public void setUp() throws Exception {
        this.configurationFactory = new ConfigurationFactory();
    }

    public void testLoadingConfiguration() throws Exception {
        this.configurationFactory.setConfigurationFileName(this.testDigesterFile.toString());
        this.compositeConfiguration = (CompositeConfiguration)this.configurationFactory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (int)3, (int)this.compositeConfiguration.getNumberOfConfigurations());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, this.compositeConfiguration.getConfiguration(1).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(1);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loades our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)this.compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        this.configuration = this.compositeConfiguration;
        Assert.assertEquals((Object)"I'm complex!", (Object)this.configuration.getProperty("element2.subelement.subsubelement"));
    }

    public void testLoadingConfigurationReverseOrder() throws Exception {
        this.configurationFactory.setConfigurationFileName(this.testDigesterFileReverseOrder.toString());
        this.configuration = this.configurationFactory.getConfiguration();
        Assert.assertEquals((Object)"8", (Object)this.configuration.getProperty("test.short"));
        this.configurationFactory.setConfigurationFileName(this.testDigesterFile.toString());
        this.configuration = this.configurationFactory.getConfiguration();
        Assert.assertEquals((Object)"1", (Object)this.configuration.getProperty("test.short"));
    }

    public void testLoadingConfigurationWithRulesXML() throws Exception {
        this.configurationFactory.setConfigurationFileName(this.testDigesterFile.toString());
        this.configurationFactory.setDigesterRules(this.digesterRules.toURL());
        this.compositeConfiguration = (CompositeConfiguration)this.configurationFactory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (int)3, (int)this.compositeConfiguration.getNumberOfConfigurations());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, this.compositeConfiguration.getConfiguration(1).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(1);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)pc.getBoolean("test.boolean"));
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)this.compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        this.configuration = this.compositeConfiguration;
        Assert.assertEquals((Object)"I'm complex!", (Object)this.configuration.getProperty("element2.subelement.subsubelement"));
    }

    public void testLoadingConfigurationNamespaceAware() throws Exception {
        this.configurationFactory.setConfigurationFileName(this.testDigesterFileNamespaceAware.toString());
        this.configurationFactory.setDigesterRuleNamespaceURI("namespace-one");
        this.compositeConfiguration = (CompositeConfiguration)this.configurationFactory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (int)2, (int)this.compositeConfiguration.getNumberOfConfigurations());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, this.compositeConfiguration.getConfiguration(1).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(1);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)pc.getBoolean("test.boolean"));
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        try {
            this.compositeConfiguration.getProperty("element2.subelement.subsubelement");
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLoadingConfigurationBasePath() throws Exception {
        this.configurationFactory.setConfigurationFileName(this.testDigesterFileBasePath.toString());
        this.configurationFactory.setBasePath(this.testBasePath);
        this.compositeConfiguration = (CompositeConfiguration)this.configurationFactory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (int)2, (int)this.compositeConfiguration.getNumberOfConfigurations());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, this.compositeConfiguration.getConfiguration(1).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)this.compositeConfiguration.getConfiguration(1);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)pc.getBoolean("test.boolean"));
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)this.compositeConfiguration.getBoolean("test.boolean"));
        try {
            this.compositeConfiguration.getProperty("element2.subelement.subsubelement");
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

