/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.cactus.ServletTestCase;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestConfigurationFactoryWithJNDI
extends ServletTestCase {
    private File testDigesterFile = new File("conf/testDigesterConfigurationWJNDI.xml");
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.TestConfigurationFactoryWithJNDI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public TestConfigurationFactoryWithJNDI(String testName) {
        super(testName);
    }

    public void testLoadingWithDigester() throws Exception {
        ConfigurationFactory cf = new ConfigurationFactory();
        cf.setConfigurationFileName(this.testDigesterFile.toString());
        CompositeConfiguration compositeConfiguration = (CompositeConfiguration)cf.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (int)4, (int)compositeConfiguration.getNumberOfConfigurations());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.JNDIConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz, compositeConfiguration.getConfiguration(1).getClass());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz2, compositeConfiguration.getConfiguration(2).getClass());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.commons.configuration.DOM4JConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertEquals(clazz3, compositeConfiguration.getConfiguration(3).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)compositeConfiguration.getConfiguration(2);
        Assert.assertNotNull((String)("Make sure we have a fileName:" + pc.getFileName()), (Object)pc.getFileName());
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((String)"Make sure the JNDI config overwrites everything else!", (Object)"80", (Object)compositeConfiguration.getString("test.overwrite"));
    }

    public void testGetKeys() throws Exception {
        ConfigurationFactory cf = new ConfigurationFactory();
        cf.setConfigurationFileName(this.testDigesterFile.toString());
        Configuration c = cf.getConfiguration();
        List iteratedList = IteratorUtils.toList((Iterator)c.getKeys());
        Assert.assertTrue((boolean)iteratedList.contains("test.jndi"));
    }

    public void testGetKeysWithString() throws Exception {
        String KEY = "test";
        ConfigurationFactory cf = new ConfigurationFactory();
        cf.setConfigurationFileName(this.testDigesterFile.toString());
        Configuration c = cf.getConfiguration();
        List iteratedList = IteratorUtils.toList((Iterator)c.getKeys(KEY));
        Assert.assertTrue((String)("Size:" + iteratedList.size()), (iteratedList.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iteratedList.contains("test.jndi"));
        Iterator i = iteratedList.iterator();
        while (i.hasNext()) {
            String foundKey = (String)i.next();
            Assert.assertTrue((boolean)foundKey.startsWith(KEY));
        }
    }

    public void testGetKeysWithString2() throws Exception {
        String KEY = "test.deep";
        ConfigurationFactory cf = new ConfigurationFactory();
        cf.setConfigurationFileName(this.testDigesterFile.toString());
        Configuration c = cf.getConfiguration();
        List iteratedList = IteratorUtils.toList((Iterator)c.getKeys(KEY));
        Assert.assertTrue((String)("Size:" + iteratedList.size()), (iteratedList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iteratedList.contains("test.deep.somekey"));
        Iterator i = iteratedList.iterator();
        while (i.hasNext()) {
            String foundKey = (String)i.next();
            Assert.assertTrue((boolean)foundKey.startsWith(KEY));
        }
    }
}

