/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.DOM4JConfiguration;

public class TestDOM4JConfiguration
extends TestCase {
    private String testProperties = new File("conf/test.xml").getAbsolutePath();
    private String testBasePath = new File("conf").getAbsolutePath();
    private DOM4JConfiguration conf;

    public TestDOM4JConfiguration(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        this.conf = new DOM4JConfiguration(new File(this.testProperties));
    }

    public void testGetProperty() throws Exception {
        Assert.assertEquals((Object)"value", (Object)this.conf.getProperty("element"));
    }

    public void testGetComplexProperty() throws Exception {
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    public void testSettingFileNames() throws Exception {
        this.conf = new DOM4JConfiguration();
        this.conf.setFileName(this.testProperties);
        Assert.assertEquals((Object)this.testProperties.toString(), (Object)this.conf.getFileName());
        this.conf.setBasePath(this.testBasePath);
        this.conf.setFileName("hello.xml");
        Assert.assertEquals((Object)"hello.xml", (Object)this.conf.getFileName());
        Assert.assertEquals((Object)this.testBasePath.toString(), (Object)this.conf.getBasePath());
        Assert.assertEquals((Object)new File(this.testBasePath, "hello.xml"), (Object)this.conf.getFile());
        this.conf.setBasePath(this.testBasePath);
        this.conf.setFileName("/subdir/hello.xml");
        Assert.assertEquals((Object)"/subdir/hello.xml", (Object)this.conf.getFileName());
        Assert.assertEquals((Object)this.testBasePath.toString(), (Object)this.conf.getBasePath());
        Assert.assertEquals((Object)new File(this.testBasePath, "/subdir/hello.xml"), (Object)this.conf.getFile());
    }

    public void testLoad() throws Exception {
        this.conf = new DOM4JConfiguration();
        this.conf.setFileName(this.testProperties);
        this.conf.load();
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    public void testLoadWithBasePath() throws Exception {
        this.conf = new DOM4JConfiguration();
        this.conf.setFileName("test.xml");
        this.conf.setBasePath(this.testBasePath);
        this.conf.load();
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }
}

