/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import junit.framework.Assert;
import org.apache.cactus.ServletTestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class TestJNDIAndCompositeConfiguration
extends ServletTestCase {
    private String testProperties = new File("conf/test.properties").getAbsolutePath();
    private CompositeConfiguration cc;
    private PropertiesConfiguration conf1;
    private JNDIConfiguration jndiConf;

    public TestJNDIAndCompositeConfiguration(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.jndiConf = new JNDIConfiguration();
        this.jndiConf.setPrefix("java:comp/env");
        this.cc = new CompositeConfiguration();
        this.conf1 = new PropertiesConfiguration(this.testProperties);
        this.cc.addConfiguration(this.jndiConf);
        this.cc.addConfiguration(this.conf1);
    }

    public void testSimpleGet() throws Exception {
        String s = this.cc.getString("test.overwrite");
        Assert.assertEquals((Object)"80", (Object)s);
        this.cc.clear();
        this.cc.addConfiguration(this.conf1);
        this.cc.addConfiguration(this.jndiConf);
        Assert.assertEquals((Object)"1", (Object)this.cc.getString("test.overwrite"));
    }

    public void testClearingProperty() throws Exception {
        this.cc.clearProperty("test.short");
        Assert.assertTrue((String)"Make sure test.short is gone!", (!this.cc.containsKey("test.short") ? 1 : 0) != 0);
    }

    public void testAddingProperty() throws Exception {
        this.cc.addProperty("test.short", "88");
        Assert.assertEquals((String)"Make sure test.short is overridden!", (Object)"88", (Object)this.cc.getString("test.short"));
    }

    public void testSettingMissingProperty() throws Exception {
        this.cc.setProperty("my.new.property", "supernew");
        Assert.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }
}

