/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import junit.framework.Assert;
import org.apache.cactus.ServletTestCase;
import org.apache.commons.configuration.JNDIConfiguration;

public class TestJNDIEnvironmentValues
extends ServletTestCase {
    public TestJNDIEnvironmentValues(String testName) {
        super(testName);
    }

    public void testSimpleGet() throws Exception {
        JNDIConfiguration conf = new JNDIConfiguration();
        conf.setPrefix("java:comp/env");
        String s = conf.getString("test/key");
        Assert.assertEquals((Object)"jndivalue", (Object)s);
    }

    public void testSimpleGet2() throws Exception {
        JNDIConfiguration conf = new JNDIConfiguration();
        conf.setPrefix("java:comp");
        String s = conf.getString("env/test/key");
        Assert.assertEquals((Object)"jndivalue", (Object)s);
    }

    public void testMoreGets() throws Exception {
        JNDIConfiguration conf = new JNDIConfiguration();
        conf.setPrefix("java:comp/env");
        String s = conf.getString("test/key");
        Assert.assertEquals((Object)"jndivalue", (Object)s);
        Assert.assertEquals((Object)"jndivalue2", (Object)conf.getString("test.key2"));
        Assert.assertEquals((int)1, (int)conf.getShort("test.short"));
    }

    public void testGetMissingKey() throws Exception {
        JNDIConfiguration conf = new JNDIConfiguration();
        conf.setPrefix("java:comp/env");
        Assert.assertNull((Object)conf.getString("test/imaginarykey"));
    }

    public void testContainsKey() throws Exception {
        JNDIConfiguration conf = new JNDIConfiguration();
        conf.setPrefix("java:comp/env");
        Assert.assertTrue((boolean)conf.containsKey("test/key"));
        Assert.assertTrue((!conf.containsKey("test/imaginerykey") ? 1 : 0) != 0);
    }
}

