/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.configuration.BasePathConfiguration;
import org.apache.commons.lang.StringUtils;

public abstract class BasePropertiesConfiguration
extends BasePathConfiguration {
    private boolean includesAllowed = false;
    protected static String include = "include";

    protected abstract InputStream getPropertyStream(String var1) throws IOException;

    public void load(InputStream input) throws IOException {
        this.load(input, null);
    }

    public synchronized void load(InputStream input, String enc) throws IOException {
        String line;
        PropertiesReader reader = null;
        if (enc != null) {
            try {
                reader = new PropertiesReader(new InputStreamReader(input, enc));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (reader == null) {
            reader = new PropertiesReader(new InputStreamReader(input));
        }
        while ((line = reader.readProperty()) != null) {
            int equalSign = line.indexOf(61);
            if (equalSign <= 0) continue;
            String key = line.substring(0, equalSign).trim();
            String value = line.substring(equalSign + 1).trim();
            if (StringUtils.isNotEmpty((String)this.getInclude()) && key.equalsIgnoreCase(this.getInclude())) {
                if (!this.getIncludesAllowed()) continue;
                String[] files = StringUtils.split((String)value, (String)",");
                int cnt = 0;
                while (cnt < files.length) {
                    this.load(this.getPropertyStream(files[cnt].trim()));
                    ++cnt;
                }
                continue;
            }
            this.addProperty(key, value);
        }
    }

    public void save(String filename) throws IOException {
        File file = new File(filename);
        PropertiesWriter out = new PropertiesWriter(file);
        out.writeComment("written by PropertiesConfiguration");
        out.writeComment(new Date().toString());
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = StringUtils.join((Object[])this.getStringArray(key), (String)", ");
            out.writeProperty(key, value);
        }
        out.flush();
        out.close();
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String inc) {
        include = inc;
    }

    protected void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean getIncludesAllowed() {
        return this.includesAllowed;
    }

    class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (StringUtils.isEmpty((String)(line = line.trim())) || line.charAt(0) == '#') continue;
                if (!line.endsWith("\\")) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }
    }

    class PropertiesWriter
    extends FileWriter {
        public PropertiesWriter(File file) throws IOException {
            super(file);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(key);
            this.write(" = ");
            this.write(value != null ? value : "");
            this.write(10);
        }

        public void writeComment(String comment) throws IOException {
            this.write("# " + comment + "\n");
        }
    }
}

