/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class CompositeConfiguration
implements Configuration {
    private ArrayList configList = new ArrayList();
    private BaseConfiguration inMemoryConfiguration = new BaseConfiguration();

    public CompositeConfiguration() {
        this.addConfiguration(this.inMemoryConfiguration);
    }

    public void addConfiguration(Configuration config) {
        if (!this.configList.contains(config)) {
            this.configList.add(config);
        }
    }

    public void removeConfiguration(Configuration config) {
        ((AbstractCollection)this.configList).remove(config);
    }

    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    public void clear() {
        this.configList.clear();
        this.inMemoryConfiguration = new BaseConfiguration();
        this.addConfiguration(this.inMemoryConfiguration);
    }

    public void addProperty(String key, Object token) {
        this.inMemoryConfiguration.addProperty(key, token);
    }

    public Iterator getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            Iterator j = config.getKeys();
            while (j.hasNext()) {
                String key = (String)j.next();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys.iterator();
    }

    public Iterator getKeys(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            Iterator j = config.getKeys(key);
            while (j.hasNext()) {
                String newKey = (String)j.next();
                if (keys.contains(newKey)) continue;
                keys.add(newKey);
            }
        }
        return keys.iterator();
    }

    public Properties getProperties(String key) {
        return this.getFirstMatchingConfig(key).getProperties(key);
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (config.isEmpty()) continue;
            return false;
        }
        return isEmpty;
    }

    public Object getProperty(String key) {
        return this.getFirstMatchingConfig(key).getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public void clearProperty(String key) {
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            config.clearProperty(key);
        }
    }

    public boolean containsKey(String key) {
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public Configuration subset(String prefix) {
        CompositeConfiguration subsetCompositeConfiguration = new CompositeConfiguration();
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            Configuration subset = config.subset(prefix);
            if (subset == null) continue;
            subsetCompositeConfiguration.addConfiguration(subset);
        }
        return subsetCompositeConfiguration;
    }

    public float getFloat(String key) {
        return this.getFirstMatchingConfig(key).getFloat(key);
    }

    public boolean getBoolean(String key) {
        return this.getFirstMatchingConfig(key).getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getBoolean(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getFirstMatchingConfig(key).getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, (byte)new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getByte(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getFirstMatchingConfig(key).getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getDouble(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getFloat(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getFirstMatchingConfig(key).getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInteger(key, new Integer(defaultValue));
    }

    public Integer getInteger(String key, Integer defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getInteger(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getFirstMatchingConfig(key).getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getLong(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public short getShort(String key) {
        return this.getFirstMatchingConfig(key).getShort(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getShort(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getString(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    public String[] getStringArray(String key) {
        try {
            return this.getFirstMatchingConfig(key).getStringArray(key);
        }
        catch (NoSuchElementException nsee) {
            return new String[0];
        }
    }

    public Vector getVector(String key) {
        try {
            return this.getFirstMatchingConfig(key).getVector(key);
        }
        catch (NoSuchElementException nsee) {
            return new Vector();
        }
    }

    public Vector getVector(String key, Vector defaultValue) {
        try {
            return this.getFirstMatchingConfig(key).getVector(key, defaultValue);
        }
        catch (NoSuchElementException nsee) {
            return defaultValue;
        }
    }

    private Configuration getFirstMatchingConfig(String key) {
        ListIterator i = ((AbstractList)this.configList).listIterator();
        while (i.hasNext()) {
            Configuration config = (Configuration)i.next();
            if (!config.containsKey(key)) continue;
            return config;
        }
        throw new NoSuchElementException(String.valueOf('\'') + key + "' doesn't map to an existing object");
    }

    public Configuration getConfiguration(int index) {
        return (Configuration)this.configList.get(index);
    }
}

