/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.BasePathConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigurationFactory {
    private String configurationFileName;
    private String basePath;
    private static Log log;
    private URL digesterRules;
    private String digesterRuleNamespaceURI;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.ConfigurationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ConfigurationFactory() {
    }

    public ConfigurationFactory(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public Configuration getConfiguration() throws Exception {
        Digester digester;
        CompositeConfiguration configuration = new CompositeConfiguration();
        FileInputStream input = new FileInputStream(new File(this.getConfigurationFileName()));
        if (this.getDigesterRules() == null) {
            digester = new Digester();
            this.configureNamespace(digester);
            this.initDefaultDigesterRules(digester);
        } else {
            digester = DigesterLoader.createDigester((URL)this.getDigesterRules());
            this.configureNamespace(digester);
        }
        digester.push((Object)configuration);
        try {
            digester.parse((InputStream)input);
            ((InputStream)input).close();
        }
        catch (SAXException e) {
            log.error((Object)"SAX Exception caught", (Throwable)e);
            throw e;
        }
        return configuration;
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public URL getDigesterRules() {
        return this.digesterRules;
    }

    public void setDigesterRules(URL digesterRules) {
        this.digesterRules = digesterRules;
    }

    protected void initDefaultDigesterRules(Digester digester) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.commons.configuration.PropertiesConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setupDigesterInstance(digester, "configuration/properties", new BasePathConfigurationFactory(clazz));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.apache.commons.configuration.DOM4JConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setupDigesterInstance(digester, "configuration/dom4j", new BasePathConfigurationFactory(clazz2));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.commons.configuration.JNDIConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setupDigesterInstance(digester, "configuration/jndi", new JNDIConfigurationFactory(clazz3));
    }

    protected void setupDigesterInstance(Digester digester, String matchString, ObjectCreationFactory factory) {
        digester.addFactoryCreate(matchString, factory);
        digester.addSetProperties(matchString);
        digester.addCallMethod(matchString, "load");
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.apache.commons.configuration.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        digester.addSetNext(matchString, "addConfiguration", clazz.getName());
    }

    protected void setupDigesterInstance(Digester digester, String matchString, JNDIConfigurationFactory factory) {
        digester.addFactoryCreate(matchString, (ObjectCreationFactory)factory);
        digester.addSetProperties(matchString);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.apache.commons.configuration.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        digester.addSetNext(matchString, "addConfiguration", clazz.getName());
    }

    public String getDigesterRuleNamespaceURI() {
        return this.digesterRuleNamespaceURI;
    }

    public void setDigesterRuleNamespaceURI(String digesterRuleNamespaceURI) {
        this.digesterRuleNamespaceURI = digesterRuleNamespaceURI;
    }

    private void configureNamespace(Digester digester) {
        if (this.getDigesterRuleNamespaceURI() != null) {
            digester.setNamespaceAware(true);
            digester.setRuleNamespaceURI(this.getDigesterRuleNamespaceURI());
        } else {
            digester.setNamespaceAware(false);
        }
        digester.setValidating(false);
    }

    public String getBasePath() {
        return StringUtils.isEmpty((String)this.basePath) ? "." : this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public class BasePathConfigurationFactory
    extends AbstractObjectCreationFactory
    implements ObjectCreationFactory {
        private Class clazz;

        public BasePathConfigurationFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object createObject(Attributes attributes) throws Exception {
            BasePathConfiguration bpc = (BasePathConfiguration)this.clazz.newInstance();
            bpc.setBasePath(ConfigurationFactory.this.getBasePath());
            return bpc;
        }
    }

    public class JNDIConfigurationFactory
    extends AbstractObjectCreationFactory
    implements ObjectCreationFactory {
        private Class clazz;

        public JNDIConfigurationFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object createObject(Attributes attributes) throws Exception {
            JNDIConfiguration jndi = (JNDIConfiguration)this.clazz.newInstance();
            return jndi;
        }
    }
}

