/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DOM4JConfiguration
extends XMLConfiguration {
    private static final char ATTRIB_MARKER = '@';
    private static final String ATTRIB_START_MARKER = "[@";
    protected String fileSeparator = System.getProperty("file.separator");
    private static final String NODE_DELIMITER = ".";
    private String fileName;
    private Document document;
    private boolean autoSave = false;
    static /* synthetic */ Class class$0;

    public DOM4JConfiguration() {
    }

    public DOM4JConfiguration(String resource) throws Exception {
        this.setFile(DOM4JConfiguration.resourceURLToFile(resource));
        this.load();
    }

    public DOM4JConfiguration(File file) throws Exception {
        this.setFile(file);
        this.load();
    }

    public void load() throws Exception {
        this.document = new SAXReader().read(this.getFile());
        this.initProperties(this.document.getRootElement(), new StringBuffer());
    }

    private static File resourceURLToFile(String resource) {
        URL confURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.DOM4JConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((confURL = clazz.getClassLoader().getResource(resource)) == null) {
            confURL = ClassLoader.getSystemResource(resource);
        }
        return new File(confURL.getFile());
    }

    private void initProperties(Element element, StringBuffer hierarchy) {
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            StringBuffer subhierarchy = new StringBuffer(hierarchy.toString());
            Element child = (Element)it.next();
            String nodeName = child.getName();
            String nodeValue = child.getTextTrim();
            subhierarchy.append(nodeName);
            if (nodeValue.length() > 0) {
                super.addProperty(subhierarchy.toString(), nodeValue);
            }
            List attributes = child.attributes();
            int j = 0;
            int k = attributes.size();
            while (j < k) {
                Attribute a = (Attribute)attributes.get(j);
                String attName = String.valueOf(subhierarchy.toString()) + '[' + '@' + a.getName() + ']';
                String attValue = a.getValue();
                super.addProperty(attName, attValue);
                ++j;
            }
            StringBuffer buf = new StringBuffer(subhierarchy.toString());
            this.initProperties(child, buf.append('.'));
        }
    }

    public void addProperty(String name, Object value) {
        super.addProperty(name, value);
        this.setXmlProperty(name, value);
        this.possiblySave();
    }

    public void setProperty(String name, Object value) {
        super.setProperty(name, value);
        this.setXmlProperty(name, value);
        this.possiblySave();
    }

    private void setXmlProperty(String name, Object value) {
        String[] nodes = StringUtils.split((String)name, (String)NODE_DELIMITER);
        String attName = null;
        Element element = this.document.getRootElement();
        int i = 0;
        while (i < nodes.length) {
            String eName = nodes[i];
            int index = eName.indexOf(ATTRIB_START_MARKER);
            if (index > -1) {
                attName = eName.substring(index + ATTRIB_START_MARKER.length(), eName.length() - 1);
                eName = eName.substring(0, index);
            }
            if (element.element(eName) == null && attName == null) {
                element.addElement(eName);
            }
            element = element.element(eName);
            ++i;
        }
        if (attName == null) {
            element.setText((String)value);
        } else {
            element.addAttribute(attName, (String)value);
        }
    }

    public void clearProperty(String name) {
        super.clearProperty(name);
        this.clearXmlProperty(name);
        this.possiblySave();
    }

    private void clearXmlProperty(String name) {
        String[] nodes = StringUtils.split((String)name, (String)NODE_DELIMITER);
        String attName = null;
        Element element = this.document.getRootElement();
        int i = 0;
        while (i < nodes.length) {
            String eName = nodes[i];
            int index = eName.indexOf(ATTRIB_START_MARKER);
            if (index > -1) {
                attName = eName.substring(index + ATTRIB_START_MARKER.length(), eName.length() - 1);
                eName = eName.substring(0, index);
            }
            if ((element = element.element(eName)) == null) {
                return;
            }
            ++i;
        }
        if (attName == null) {
            element.remove(element.element(nodes[nodes.length - 1]));
        } else {
            element.remove(element.attribute(attName));
        }
    }

    private void possiblySave() {
        if (this.autoSave) {
            try {
                this.save();
            }
            catch (IOException e) {
                throw new NestableRuntimeException("Failed to auto-save", (Throwable)e);
            }
        }
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public synchronized void save() throws IOException {
        block5: {
            XMLWriter writer = null;
            OutputStream out = null;
            try {
                OutputFormat outputter = OutputFormat.createPrettyPrint();
                out = new BufferedOutputStream(new FileOutputStream(this.getFile()));
                writer = new XMLWriter(out, outputter);
                writer.write(this.document);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            Object var4_6 = null;
            if (out != null) {
                out.close();
            }
            if (writer == null) break block5;
            writer.close();
        }
    }

    public File getFile() {
        File file = null;
        if (StringUtils.isEmpty((String)this.getBasePath())) {
            file = new File(this.getFileName());
        } else {
            StringBuffer fileName = new StringBuffer();
            fileName.append(this.getBasePath());
            if (!this.getBasePath().endsWith(this.fileSeparator)) {
                fileName.append(this.fileSeparator);
            }
            if (this.getFileName().startsWith(NODE_DELIMITER + this.fileSeparator)) {
                fileName.append(this.getFileName().substring(2));
            } else {
                fileName.append(this.getFileName());
            }
            file = new File(fileName.toString());
        }
        return file;
    }

    public void setFile(File file) {
        this.fileName = file.getAbsolutePath();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }
}

