/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import junit.framework.Assert;
import org.apache.commons.configuration.Configuration;

public class NonStringTestHolder {
    private Configuration configuration;

    public void testBoolean() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean");
        Assert.assertEquals((boolean)true, (boolean)booleanValue);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.boolean").size());
    }

    public void testBooleanDefaultValue() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean.missing", true);
        Assert.assertEquals((boolean)true, (boolean)booleanValue);
        Boolean booleanObject = this.configuration.getBoolean("test.boolean.missing", new Boolean(true));
        Assert.assertEquals((Object)new Boolean(true), (Object)booleanObject);
    }

    public void testByte() throws Exception {
        byte testValue = 10;
        byte byteValue = this.configuration.getByte("test.byte");
        Assert.assertEquals((byte)testValue, (byte)byteValue);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.byte").size());
    }

    public void testDouble() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double");
        Assert.assertEquals((double)testValue, (double)doubleValue, (double)0.01);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.double").size());
    }

    public void testDoubleDefaultValue() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double.missing", 10.25);
        Assert.assertEquals((double)testValue, (double)doubleValue, (double)0.01);
    }

    public void testFloat() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float");
        Assert.assertEquals((double)testValue, (double)floatValue, (double)0.01);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.float").size());
    }

    public void testFloatDefaultValue() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float.missing", testValue);
        Assert.assertEquals((double)testValue, (double)floatValue, (double)0.01);
    }

    public void testInteger() throws Exception {
        int intValue = this.configuration.getInt("test.integer");
        Assert.assertEquals((int)10, (int)intValue);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.integer").size());
    }

    public void testIntegerDefaultValue() throws Exception {
        int intValue = this.configuration.getInt("test.integer.missing", 10);
        Assert.assertEquals((int)10, (int)intValue);
    }

    public void testLong() throws Exception {
        long longValue = this.configuration.getLong("test.long");
        Assert.assertEquals((long)1000000L, (long)longValue);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.long").size());
    }

    public void testLongDefaultValue() throws Exception {
        long longValue = this.configuration.getLong("test.long.missing", 1000000L);
        Assert.assertEquals((long)1000000L, (long)longValue);
    }

    public void testShort() throws Exception {
        short shortValue = this.configuration.getShort("test.short");
        Assert.assertEquals((int)1, (int)shortValue);
        Assert.assertEquals((int)1, (int)this.configuration.getVector("test.short").size());
    }

    public void testShortDefaultValue() throws Exception {
        short shortValue = this.configuration.getShort("test.short.missing", (short)1);
        Assert.assertEquals((int)1, (int)shortValue);
    }

    public void testVectorMissing() throws Exception {
        Assert.assertEquals((int)0, (int)this.configuration.getVector("missing.vector").size());
    }

    public void testSubset() throws Exception {
        String KEY_VALUE = "test.short";
        Configuration subset = this.configuration.subset(KEY_VALUE);
        boolean foundKeyValue = false;
        Iterator i = subset.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals(KEY_VALUE)) {
                Assert.assertTrue((String)("Key is:" + key), (!key.startsWith("test.short") ? 1 : 0) != 0);
                continue;
            }
            foundKeyValue = true;
        }
        Assert.assertTrue((String)"Make sure test.short did show up.  It is valid.", (boolean)foundKeyValue);
    }

    public void testIsEmpty() throws Exception {
        Assert.assertTrue((!this.configuration.isEmpty() ? 1 : 0) != 0);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

