/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Properties;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class TestBaseConfiguration
extends TestCase {
    protected BaseConfiguration eprop = new BaseConfiguration();
    static /* synthetic */ Class class$0;

    public TestBaseConfiguration(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.TestBaseConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.configuration.TestBaseConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    public void testRetrieve() {
        Assert.assertEquals((String)"This returns null", (Object)this.eprop.getProperty("foo"), null);
        this.eprop.setProperty("number", "1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.eprop.getProperty("number"), (Object)"1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.eprop.getString("number"), (Object)"1");
        byte oneB = 1;
        byte twoB = 2;
        Assert.assertEquals((String)"This returns 1(byte)", (byte)this.eprop.getByte("number"), (byte)oneB);
        Assert.assertEquals((String)"This returns 1(byte)", (byte)this.eprop.getByte("number", twoB), (byte)oneB);
        Assert.assertEquals((String)"This returns 2(default byte)", (byte)this.eprop.getByte("numberNotInConfig", twoB), (byte)twoB);
        Assert.assertEquals((String)"This returns 1(Byte)", (Object)this.eprop.getByte("number", new Byte("2")), (Object)new Byte(oneB));
        this.eprop.setProperty("numberS", "1");
        short oneS = 1;
        short twoS = 2;
        Assert.assertEquals((String)"This returns 1(short)", (short)this.eprop.getShort("numberS"), (short)oneS);
        Assert.assertEquals((String)"This returns 1(short)", (short)this.eprop.getShort("numberS", twoS), (short)oneS);
        Assert.assertEquals((String)"This returns 2(default short)", (short)this.eprop.getShort("numberNotInConfig", twoS), (short)twoS);
        Assert.assertEquals((String)"This returns 1(Short)", (Object)this.eprop.getShort("numberS", new Short("2")), (Object)new Short(oneS));
        this.eprop.setProperty("numberL", "1");
        long oneL = 1L;
        long twoL = 2L;
        Assert.assertEquals((String)"This returns 1(long)", (long)this.eprop.getLong("numberL"), (long)oneL);
        Assert.assertEquals((String)"This returns 1(long)", (long)this.eprop.getLong("numberL", twoL), (long)oneL);
        Assert.assertEquals((String)"This returns 2(default long)", (long)this.eprop.getLong("numberNotInConfig", twoL), (long)twoL);
        Assert.assertEquals((String)"This returns 1(Long)", (Object)this.eprop.getLong("numberL", new Long("2")), (Object)new Long(oneL));
        this.eprop.setProperty("numberF", "1.0");
        float oneF = 1.0f;
        float twoF = 2.0f;
        Assert.assertEquals((String)"This returns 1(float)", (float)this.eprop.getFloat("numberF"), (float)oneF, (float)0.0f);
        Assert.assertEquals((String)"This returns 1(float)", (float)this.eprop.getFloat("numberF", twoF), (float)oneF, (float)0.0f);
        Assert.assertEquals((String)"This returns 2(default float)", (float)this.eprop.getFloat("numberNotInConfig", twoF), (float)twoF, (float)0.0f);
        Assert.assertEquals((String)"This returns 1(Float)", (Object)this.eprop.getFloat("numberF", new Float("2")), (Object)new Float(oneF));
        this.eprop.setProperty("numberD", "1.0");
        double oneD = 1.0;
        double twoD = 2.0;
        Assert.assertEquals((String)"This returns 1(double)", (double)this.eprop.getDouble("numberD"), (double)oneD, (double)0.0);
        Assert.assertEquals((String)"This returns 1(double)", (double)this.eprop.getDouble("numberD", twoD), (double)oneD, (double)0.0);
        Assert.assertEquals((String)"This returns 2(default double)", (double)this.eprop.getDouble("numberNotInConfig", twoD), (double)twoD, (double)0.0);
        Assert.assertEquals((String)"This returns 1(Double)", (Object)this.eprop.getDouble("numberD", new Double("2")), (Object)new Double(oneD));
        this.eprop.setProperty("boolA", Boolean.TRUE);
        boolean boolT = true;
        boolean boolF = false;
        Assert.assertEquals((String)"This returns true", (boolean)this.eprop.getBoolean("boolA"), (boolean)boolT);
        Assert.assertEquals((String)"This returns true, not the default", (boolean)this.eprop.getBoolean("boolA", boolF), (boolean)boolT);
        Assert.assertEquals((String)"This returns false(default)", (boolean)this.eprop.getBoolean("boolNotInConfig", boolF), (boolean)boolF);
        Assert.assertEquals((String)"This returns true(Boolean)", (Object)this.eprop.getBoolean("boolA", new Boolean(boolF)), (Object)new Boolean(boolT));
        this.eprop.addProperty("number", "2");
        Assert.assertTrue((String)"This returns array", (boolean)(this.eprop.getVector("number") instanceof Vector));
        Assert.assertTrue((String)"This returns scalar", (boolean)(this.eprop.getString("number") instanceof String));
        String prop = "hey, that's a test";
        this.eprop.setProperty("prop.string", prop);
        Assert.assertTrue((String)"This returns vector", (boolean)(this.eprop.getVector("prop.string") instanceof Vector));
        String prop2 = "hey\\, that's a test";
        this.eprop.clearProperty("prop.string");
        this.eprop.setProperty("prop.string", prop2);
        Assert.assertTrue((String)"This returns string", (boolean)(this.eprop.getString("prop.string") instanceof String));
        this.eprop.clearProperty("prop.properties");
        this.eprop.setProperty("prop.properties", "");
        Assert.assertEquals((String)"This returns an empty Properties object", (Object)this.eprop.getProperties("prop.properties"), (Object)new Properties());
        this.eprop.clearProperty("prop.properties");
        this.eprop.setProperty("prop.properties", "foo=bar, baz=moo, seal=clubber");
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("baz", "moo");
        p.setProperty("seal", "clubber");
        Assert.assertEquals((String)"This returns a filled in Properties object", (Object)this.eprop.getProperties("prop.properties"), (Object)p);
        Configuration subEprop = this.eprop.subset("prop");
        Assert.assertTrue((String)"Returns the full string", (boolean)subEprop.getString("string").equals(prop));
        Assert.assertTrue((String)"This returns string for subset", (boolean)(subEprop.getString("string") instanceof String));
        Assert.assertTrue((String)"This returns array for subset", (boolean)(subEprop.getVector("string") instanceof Vector));
    }

    public void testInterpolation() throws Exception {
        this.eprop.setProperty("applicationRoot", "/home/applicationRoot");
        this.eprop.setProperty("db", "${applicationRoot}/db/hypersonic");
        String unInterpolatedValue = "${applicationRoot2}/db/hypersonic";
        this.eprop.setProperty("dbFailedInterpolate", unInterpolatedValue);
        String dbProp = "/home/applicationRoot/db/hypersonic";
        PropertiesConfiguration superProp = new PropertiesConfiguration(this.eprop);
        Assert.assertTrue((String)"Checking interpolated variable", (boolean)superProp.getString("db").equals(dbProp));
        Assert.assertEquals((String)"lookup fails, leave variable as is", (Object)superProp.getString("dbFailedInterpolate"), (Object)unInterpolatedValue);
        superProp.setProperty("arrayInt", "${applicationRoot}/1");
        String[] arrayInt = superProp.getStringArray("arrayInt");
        Assert.assertEquals((String)"check first entry was interpolated", (Object)"/home/applicationRoot/1", (Object)arrayInt[0]);
    }

    public void testMultipleInterpolation() throws Exception {
        this.eprop.setProperty("test.base-level", "/base-level");
        this.eprop.setProperty("test.first-level", "${test.base-level}/first-level");
        this.eprop.setProperty("test.second-level", "${test.first-level}/second-level");
        this.eprop.setProperty("test.third-level", "${test.second-level}/third-level");
        String expectedValue = "/base-level/first-level/second-level/third-level";
        Assert.assertEquals((Object)this.eprop.getString("test.third-level"), (Object)expectedValue);
    }

    public void testInterpolationLoop() throws Exception {
        this.eprop.setProperty("test.a", "${test.b}");
        this.eprop.setProperty("test.b", "${test.a}");
        try {
            this.eprop.getString("test.a");
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)"IllegalStateException should have been thrown for looped property references");
    }
}

