/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.Vector;
import junit.framework.Assert;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.TestBasePropertiesConfiguration;

public class TestPropertiesConfiguration
extends TestBasePropertiesConfiguration {
    private String testProperties = new File("conf/test.properties").getAbsolutePath();
    private String testBasePath = new File("conf").getAbsolutePath();
    private String testBasePath2 = new File("conf").getAbsoluteFile().getParentFile().getAbsolutePath();

    public TestPropertiesConfiguration(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        this.conf = new PropertiesConfiguration(this.testProperties);
    }

    public void atestSave() throws Exception {
        PropertiesConfiguration toSave = new PropertiesConfiguration();
        toSave.addProperty("string", "value1");
        Vector<String> vec = new Vector<String>();
        int i = 1;
        while (i < 5) {
            vec.add("value" + i);
            ++i;
        }
        toSave.addProperty("array", vec);
        String filename = "STRING0";
        toSave.save(filename);
    }

    public void atestLoadViaProperty() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setFileName(this.testProperties);
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    public void testLoadViaPropertyWithBasePath() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setBasePath(this.testBasePath);
        pc.setFileName("test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    public void testLoadViaPropertyWithBasePath2() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setBasePath(this.testBasePath2);
        pc.setFileName("conf/test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
        pc = new PropertiesConfiguration();
        pc.setBasePath(this.testBasePath2);
        pc.setFileName("conf/test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }
}

