/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedTrace;

public class DelegatingResultSet
extends AbandonedTrace
implements ResultSet {
    private ResultSet _res;
    private Statement _stmt;

    public DelegatingResultSet(Statement stmt, ResultSet res) {
        super((AbandonedTrace)((Object)stmt));
        this._stmt = stmt;
        this._res = res;
    }

    public static ResultSet wrapResultSet(Statement stmt, ResultSet rset) {
        if (rset == null) {
            return null;
        }
        return new DelegatingResultSet(stmt, rset);
    }

    public ResultSet getDelegate() {
        return this._res;
    }

    public boolean equals(Object obj) {
        ResultSet delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingResultSet) {
            DelegatingResultSet s = (DelegatingResultSet)obj;
            return delegate.equals(s.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        ResultSet obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public ResultSet getInnermostDelegate() {
        ResultSet r = this._res;
        while (r != null && r instanceof DelegatingResultSet) {
            if (this != (r = ((DelegatingResultSet)r).getDelegate())) continue;
            return null;
        }
        return r;
    }

    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    public void close() throws SQLException {
        if (this._stmt != null) {
            ((AbandonedTrace)((Object)this._stmt)).removeTrace(this);
            this._stmt = null;
        }
        this._res.close();
    }

    public boolean next() throws SQLException {
        return this._res.next();
    }

    public boolean wasNull() throws SQLException {
        return this._res.wasNull();
    }

    public String getString(int columnIndex) throws SQLException {
        return this._res.getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this._res.getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this._res.getByte(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this._res.getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this._res.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this._res.getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this._res.getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this._res.getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this._res.getBigDecimal(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this._res.getBytes(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this._res.getDate(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this._res.getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this._res.getTimestamp(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this._res.getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this._res.getUnicodeStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this._res.getBinaryStream(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this._res.getString(columnName);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this._res.getBoolean(columnName);
    }

    public byte getByte(String columnName) throws SQLException {
        return this._res.getByte(columnName);
    }

    public short getShort(String columnName) throws SQLException {
        return this._res.getShort(columnName);
    }

    public int getInt(String columnName) throws SQLException {
        return this._res.getInt(columnName);
    }

    public long getLong(String columnName) throws SQLException {
        return this._res.getLong(columnName);
    }

    public float getFloat(String columnName) throws SQLException {
        return this._res.getFloat(columnName);
    }

    public double getDouble(String columnName) throws SQLException {
        return this._res.getDouble(columnName);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this._res.getBigDecimal(columnName);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this._res.getBytes(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        return this._res.getDate(columnName);
    }

    public Time getTime(String columnName) throws SQLException {
        return this._res.getTime(columnName);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this._res.getTimestamp(columnName);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this._res.getAsciiStream(columnName);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this._res.getUnicodeStream(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this._res.getBinaryStream(columnName);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._res.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this._res.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this._res.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._res.getMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this._res.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this._res.getObject(columnName);
    }

    public int findColumn(String columnName) throws SQLException {
        return this._res.findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this._res.getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this._res.getCharacterStream(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this._res.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this._res.getBigDecimal(columnName);
    }

    public boolean isBeforeFirst() throws SQLException {
        return this._res.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this._res.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this._res.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this._res.isLast();
    }

    public void beforeFirst() throws SQLException {
        this._res.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this._res.afterLast();
    }

    public boolean first() throws SQLException {
        return this._res.first();
    }

    public boolean last() throws SQLException {
        return this._res.last();
    }

    public int getRow() throws SQLException {
        return this._res.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        return this._res.absolute(row);
    }

    public boolean relative(int rows) throws SQLException {
        return this._res.relative(rows);
    }

    public boolean previous() throws SQLException {
        return this._res.previous();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this._res.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this._res.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this._res.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this._res.getFetchSize();
    }

    public int getType() throws SQLException {
        return this._res.getType();
    }

    public int getConcurrency() throws SQLException {
        return this._res.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this._res.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this._res.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this._res.rowDeleted();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this._res.updateNull(columnIndex);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this._res.updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this._res.updateByte(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this._res.updateShort(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this._res.updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this._res.updateLong(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this._res.updateFloat(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this._res.updateDouble(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this._res.updateBigDecimal(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this._res.updateString(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this._res.updateBytes(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this._res.updateDate(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this._res.updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this._res.updateTimestamp(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._res.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._res.updateBinaryStream(columnIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this._res.updateCharacterStream(columnIndex, x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this._res.updateObject(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this._res.updateObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this._res.updateNull(columnName);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this._res.updateBoolean(columnName, x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this._res.updateByte(columnName, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this._res.updateShort(columnName, x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this._res.updateInt(columnName, x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this._res.updateLong(columnName, x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this._res.updateFloat(columnName, x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this._res.updateDouble(columnName, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this._res.updateBigDecimal(columnName, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this._res.updateString(columnName, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this._res.updateBytes(columnName, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this._res.updateDate(columnName, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this._res.updateTime(columnName, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this._res.updateTimestamp(columnName, x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this._res.updateAsciiStream(columnName, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this._res.updateBinaryStream(columnName, x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this._res.updateCharacterStream(columnName, reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this._res.updateObject(columnName, x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this._res.updateObject(columnName, x);
    }

    public void insertRow() throws SQLException {
        this._res.insertRow();
    }

    public void updateRow() throws SQLException {
        this._res.updateRow();
    }

    public void deleteRow() throws SQLException {
        this._res.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this._res.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this._res.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this._res.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this._res.moveToCurrentRow();
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this._res.getObject(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        return this._res.getRef(i);
    }

    public Blob getBlob(int i) throws SQLException {
        return this._res.getBlob(i);
    }

    public Clob getClob(int i) throws SQLException {
        return this._res.getClob(i);
    }

    public Array getArray(int i) throws SQLException {
        return this._res.getArray(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this._res.getObject(colName, map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this._res.getRef(colName);
    }

    public Blob getBlob(String colName) throws SQLException {
        return this._res.getBlob(colName);
    }

    public Clob getClob(String colName) throws SQLException {
        return this._res.getClob(colName);
    }

    public Array getArray(String colName) throws SQLException {
        return this._res.getArray(colName);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this._res.getDate(columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this._res.getDate(columnName, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this._res.getTime(columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this._res.getTime(columnName, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this._res.getTimestamp(columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this._res.getTimestamp(columnName, cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return this._res.getURL(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        return this._res.getURL(columnName);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this._res.updateRef(columnIndex, x);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this._res.updateRef(columnName, x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this._res.updateBlob(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this._res.updateBlob(columnName, x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this._res.updateClob(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this._res.updateClob(columnName, x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this._res.updateArray(columnIndex, x);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this._res.updateArray(columnName, x);
    }
}

