/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected boolean _defaultReadOnly = false;
    protected boolean _defaultAutoCommit = true;
    protected AbandonedConfig _config = null;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (this._stmtPoolFactory != null) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PoolableConnection) {
            ((PoolableConnection)obj).reallyClose();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean validateObject(Object obj) {
        block22: {
            block17: {
                block21: {
                    if (obj instanceof Connection == false) return false;
                    query = this._validationQuery;
                    conn = (Connection)obj;
                    try {
                        if (conn.isClosed()) {
                            return false;
                        }
                    }
                    catch (SQLException e) {
                        return false;
                    }
                    if (query == null) return true;
                    stmt = null;
                    rset = null;
                    try {
                        try {
                            stmt = conn.createStatement();
                            rset = stmt.executeQuery(query);
                            if (!rset.next()) break block17;
                            var7_7 = null;
                        }
                        catch (Exception e) {
                            var7_9 = null;
                            try {
                                rset.close();
                            }
                            catch (Exception var9_13) {
                                // empty catch block
                            }
                            try {
                                stmt.close();
                                return false;
                            }
                            catch (Exception t) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                    catch (Throwable var8_16) {
                        block20: {
                            var7_10 = null;
                            ** try [egrp 3[TRYBLOCK] [5 : 100->110)] { 
lbl40:
                            // 1 sources

                            rset.close();
                            break block20;
lbl42:
                            // 1 sources

                            catch (Exception var9_14) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [6 : 112->122)] { 
lbl46:
                        // 1 sources

                        stmt.close();
                        throw var8_16;
lbl48:
                        // 1 sources

                        catch (Exception t) {
                            // empty catch block
                        }
                        throw var8_16;
                    }
                    ** try [egrp 3[TRYBLOCK] [5 : 100->110)] { 
lbl53:
                    // 1 sources

                    rset.close();
                    break block21;
lbl55:
                    // 1 sources

                    catch (Exception var9_11) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [6 : 112->122)] { 
lbl59:
                // 1 sources

                stmt.close();
                return true;
lbl61:
                // 1 sources

                catch (Exception t) {
                    // empty catch block
                }
                return true;
            }
            var7_8 = null;
            ** try [egrp 3[TRYBLOCK] [5 : 100->110)] { 
lbl67:
            // 1 sources

            rset.close();
            break block22;
lbl69:
            // 1 sources

            catch (Exception var9_12) {
                // empty catch block
            }
        }
        ** try [egrp 4[TRYBLOCK] [6 : 112->122)] { 
lbl73:
        // 1 sources

        stmt.close();
        return false;
lbl75:
        // 1 sources

        catch (Exception t) {
            // empty catch block
        }
        return false;
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
            conn.clearWarnings();
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public void activateObject(Object obj) throws Exception {
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).activate();
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            conn.setAutoCommit(this._defaultAutoCommit);
            conn.setReadOnly(this._defaultReadOnly);
        }
    }
}

