/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.dbcp.DelegatingConnection;

public abstract class TestConnectionPool
extends TestCase {
    public TestConnectionPool(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected abstract Connection getConnection() throws Exception;

    protected int getMaxActive() {
        return 10;
    }

    protected long getMaxWait() {
        return 100L;
    }

    public void testClearWarnings() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            c[i].prepareCall("warning");
            ++i;
        }
        i = 0;
        while (i < c.length) {
            Assert.assertNotNull((Object)c[i].getWarnings());
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i] = this.getConnection();
            ++i;
        }
        i = 0;
        while (i < c.length) {
            Assert.assertNull((Object)c[i].getWarnings());
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testIsClosed() throws Exception {
        int i = 0;
        while (i < this.getMaxActive()) {
            Connection conn = this.getConnection();
            Assert.assertTrue((conn != null ? 1 : 0) != 0);
            Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertTrue((stmt != null ? 1 : 0) != 0);
            ResultSet rset = stmt.executeQuery();
            Assert.assertTrue((rset != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
            Assert.assertTrue((boolean)conn.isClosed());
            ++i;
        }
    }

    public void testCantCloseConnectionTwice() throws Exception {
        int i = 0;
        while (i < this.getMaxActive()) {
            Connection conn = this.getConnection();
            Assert.assertTrue((conn != null ? 1 : 0) != 0);
            Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
            conn.close();
            Assert.assertTrue((boolean)conn.isClosed());
            try {
                conn.close();
                Assert.fail((String)("Expected SQLException on second attempt to close (" + conn.getClass().getName() + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)conn.isClosed());
            ++i;
        }
    }

    public void testCantCloseStatementTwice() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        Assert.assertTrue((!conn.isClosed() ? 1 : 0) != 0);
        int i = 0;
        while (i < 2) {
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertTrue((stmt != null ? 1 : 0) != 0);
            stmt.close();
            try {
                stmt.close();
                Assert.fail((String)("Expected SQLException on second attempt to close (" + stmt.getClass().getName() + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++i;
        }
        conn.close();
    }

    public void testSimple() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        ResultSet rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testRepeatedBorrowAndReturn() throws Exception {
        int i = 0;
        while (i < 100) {
            Connection conn = this.getConnection();
            Assert.assertTrue((conn != null ? 1 : 0) != 0);
            PreparedStatement stmt = conn.prepareStatement("select * from dual");
            Assert.assertTrue((stmt != null ? 1 : 0) != 0);
            ResultSet rset = stmt.executeQuery();
            Assert.assertTrue((rset != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rset.next());
            rset.close();
            stmt.close();
            conn.close();
            ++i;
        }
    }

    public void testSimple2() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        ResultSet rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            conn.createStatement();
            Assert.fail((String)"Can't use closed connections");
        }
        catch (SQLException stmt2) {
            // empty catch block
        }
        conn = this.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    public void testPooling() throws Exception {
        Connection conn = this.getConnection();
        Connection underconn = null;
        if (!(conn instanceof DelegatingConnection)) {
            return;
        }
        underconn = ((DelegatingConnection)conn).getInnermostDelegate();
        Assert.assertTrue((underconn != null ? 1 : 0) != 0);
        Connection conn2 = this.getConnection();
        Connection underconn2 = null;
        if (!(conn2 instanceof DelegatingConnection)) {
            return;
        }
        underconn2 = ((DelegatingConnection)conn2).getInnermostDelegate();
        Assert.assertTrue((underconn2 != null ? 1 : 0) != 0);
        Assert.assertTrue((underconn != underconn2 ? 1 : 0) != 0);
        conn2.close();
        conn.close();
        Connection conn3 = this.getConnection();
        Connection underconn3 = null;
        if (!(conn3 instanceof DelegatingConnection)) {
            return;
        }
        underconn3 = ((DelegatingConnection)conn3).getInnermostDelegate();
        Assert.assertTrue((underconn3 == underconn || underconn3 == underconn2 ? 1 : 0) != 0);
        conn3.close();
    }

    public void testAutoCommitBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)conn.getAutoCommit());
        conn.setAutoCommit(false);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertTrue((boolean)conn2.getAutoCommit());
        Connection conn3 = this.getConnection();
        Assert.assertTrue((boolean)conn3.getAutoCommit());
        conn2.close();
        conn3.close();
    }

    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < conn.length) {
            conn[i] = this.getConnection();
            int j = 0;
            while (j < i) {
                Assert.assertTrue((conn[j] != conn[i] ? 1 : 0) != 0);
                Assert.assertTrue((!conn[j].equals(conn[i]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < conn.length) {
            conn[i].close();
            ++i;
        }
    }

    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            int j = 0;
            while (j <= i) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.getConnection();
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.getConnection();
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testMaxActive() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i22 = 0;
        while (i22 < c.length) {
            c[i22] = this.getConnection();
            Assert.assertTrue((c[i22] != null ? 1 : 0) != 0);
            ++i22;
        }
        try {
            this.getConnection();
            Assert.fail((String)"Allowed to open more than DefaultMaxActive connections.");
        }
        catch (SQLException i22) {
            // empty catch block
        }
        int i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testThreaded() {
        threads = new TestThread[this.getMaxActive()];
        i = 0;
        while (i < threads.length) {
            threads[i] = new TestThread(50, 50);
            t = new Thread(threads[i]);
            t.start();
            ++i;
        }
        i = 0;
        ** GOTO lbl21
        {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_4) {
                // empty catch block
            }
            do {
                if (!threads[i].complete()) continue block3;
                if (threads[i].failed()) {
                    Assert.fail();
                }
                ++i;
lbl21:
                // 2 sources

            } while (i < threads.length);
        }
    }

    class TestThread
    implements Runnable {
        Random _random = new Random();
        boolean _complete = false;
        boolean _failed = false;
        int _iter = 100;
        int _delay = 50;

        public TestThread() {
        }

        public TestThread(int iter) {
            this._iter = iter;
        }

        public TestThread(int iter, int delay) {
            this._iter = iter;
            this._delay = delay;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            i = 0;
            while (i < this._iter) {
                block28: {
                    block27: {
                        block26: {
                            try {
                                Thread.sleep(this._random.nextInt(this._delay));
                            }
                            catch (Exception var2_3) {
                                // empty catch block
                            }
                            conn = null;
                            stmt = null;
                            rset = null;
                            try {
                                try {
                                    conn = TestConnectionPool.this.getConnection();
                                    stmt = conn.prepareStatement("select 'literal', SYSDATE from dual");
                                    rset = stmt.executeQuery();
                                    try {
                                        Thread.sleep(this._random.nextInt(this._delay));
                                    }
                                    catch (Exception e) {}
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this._failed = true;
                                    this._complete = true;
                                    var6_8 = null;
                                    try {
                                        rset.close();
                                    }
                                    catch (Exception var8_9) {
                                        // empty catch block
                                    }
                                    try {
                                        stmt.close();
                                    }
                                    catch (Exception var8_9) {
                                        // empty catch block
                                    }
                                    try {
                                        conn.close();
                                    }
                                    catch (Exception e) {}
                                    break;
                                }
                            }
                            catch (Throwable var7_10) {
                                block25: {
                                    block24: {
                                        var6_8 = null;
                                        ** try [egrp 4[TRYBLOCK] [5 : 112->122)] { 
lbl48:
                                        // 1 sources

                                        rset.close();
                                        break block24;
lbl50:
                                        // 1 sources

                                        catch (Exception var8_9) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 5[TRYBLOCK] [6 : 124->133)] { 
lbl54:
                                    // 1 sources

                                    stmt.close();
                                    break block25;
lbl56:
                                    // 1 sources

                                    catch (Exception var8_9) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [7 : 135->144)] { 
lbl60:
                                // 1 sources

                                conn.close();
                                throw var7_10;
lbl62:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                throw var7_10;
                            }
                            {
                                var6_8 = null;
                            }
                            ** try [egrp 4[TRYBLOCK] [5 : 112->122)] { 
lbl67:
                            // 1 sources

                            rset.close();
                            break block26;
lbl69:
                            // 1 sources

                            catch (Exception var8_9) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [6 : 124->133)] { 
lbl73:
                        // 1 sources

                        stmt.close();
                        break block27;
lbl75:
                        // 1 sources

                        catch (Exception var8_9) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [7 : 135->144)] { 
lbl79:
                    // 1 sources

                    conn.close();
                    break block28;
lbl81:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this._complete = true;
        }
    }
}

