/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.TesterConnection;
import org.apache.commons.dbcp.TesterPreparedStatement;

public class TestDelegatingPreparedStatement
extends TestCase {
    private DelegatingConnection conn = null;
    private Connection delegateConn = null;
    private DelegatingPreparedStatement stmt = null;
    private PreparedStatement delegateStmt = null;
    static /* synthetic */ Class class$0;

    public TestDelegatingPreparedStatement(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.apache.commons.dbcp.TestDelegatingPreparedStatement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection();
        this.conn = new DelegatingConnection(this.delegateConn);
    }

    public void testExecuteQueryReturnsNull() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "null");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        Assert.assertNull((Object)this.stmt.executeQuery());
    }

    public void testExecuteQueryReturnsNotNull() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        Assert.assertTrue((this.stmt.executeQuery() != null ? 1 : 0) != 0);
    }

    public void testGetDelegate() throws Exception {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        Assert.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }

    public void testHashCodeNull() {
        this.stmt = new DelegatingPreparedStatement(this.conn, null);
        Assert.assertEquals((int)0, (int)this.stmt.hashCode());
    }

    public void testHashCode() {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        DelegatingPreparedStatement stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        DelegatingPreparedStatement stmt2 = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        Assert.assertEquals((int)stmt.hashCode(), (int)stmt2.hashCode());
    }

    public void testEquals() {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        DelegatingPreparedStatement stmt = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        DelegatingPreparedStatement stmt2 = new DelegatingPreparedStatement(this.conn, this.delegateStmt);
        DelegatingPreparedStatement stmt3 = new DelegatingPreparedStatement(this.conn, null);
        Assert.assertTrue((!stmt.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.equals(stmt2));
        Assert.assertTrue((!stmt.equals(stmt3) ? 1 : 0) != 0);
    }
}

