/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.TesterConnection;
import org.apache.commons.dbcp.TesterPreparedStatement;
import org.apache.commons.dbcp.TesterStatement;

public class TestDelegatingStatement
extends TestCase {
    private DelegatingConnection conn = null;
    private Connection delegateConn = null;
    private DelegatingStatement stmt = null;
    private Statement delegateStmt = null;
    static /* synthetic */ Class class$0;

    public TestDelegatingStatement(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.apache.commons.dbcp.TestDelegatingStatement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection();
        this.delegateStmt = new TesterStatement(this.delegateConn);
        this.conn = new DelegatingConnection(this.delegateConn);
        this.stmt = new DelegatingStatement(this.conn, this.delegateStmt);
    }

    public void testExecuteQueryReturnsNull() throws Exception {
        Assert.assertNull((Object)this.stmt.executeQuery("null"));
    }

    public void testGetDelegate() throws Exception {
        Assert.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }

    public void testHashCode() {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        DelegatingStatement stmt = new DelegatingStatement(this.conn, this.delegateStmt);
        DelegatingStatement stmt2 = new DelegatingStatement(this.conn, this.delegateStmt);
        Assert.assertEquals((int)stmt.hashCode(), (int)stmt2.hashCode());
    }

    public void testEquals() {
        this.delegateStmt = new TesterPreparedStatement(this.delegateConn, "select * from foo");
        DelegatingStatement stmt = new DelegatingStatement(this.conn, this.delegateStmt);
        DelegatingStatement stmt2 = new DelegatingStatement(this.conn, this.delegateStmt);
        DelegatingStatement stmt3 = new DelegatingStatement(this.conn, null);
        Assert.assertTrue((!stmt.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.equals(stmt2));
        Assert.assertTrue((!stmt.equals(stmt3) ? 1 : 0) != 0);
    }
}

