/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.DriverManager;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.dbcp.TestConnectionPool;
import org.apache.commons.dbcp.TesterDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class TestManual
extends TestConnectionPool {
    private PoolingDriver driver = null;
    static /* synthetic */ Class class$0;

    public TestManual(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.apache.commons.dbcp.TestManual;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected Connection getConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
    }

    public void setUp() throws Exception {
        super.setUp();
        GenericObjectPool pool = new GenericObjectPool(null, this.getMaxActive(), 1, this.getMaxWait(), 10, true, true, 10000L, 5, 5000L, true);
        DriverConnectionFactory cf = new DriverConnectionFactory(new TesterDriver(), "jdbc:apache:commons:testdriver", null);
        GenericKeyedObjectPoolFactory opf = new GenericKeyedObjectPoolFactory(null, 10, 1, 2000L, 10, true, true, 10000L, 5, 5000L, true);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory(cf, (ObjectPool)pool, (KeyedObjectPoolFactory)opf, "SELECT COUNT(*) FROM DUAL", false, true);
        Assert.assertNotNull((Object)pcf);
        this.driver = new PoolingDriver();
        this.driver.registerPool("test", (ObjectPool)pool);
        DriverManager.registerDriver(this.driver);
    }

    public void tearDown() throws Exception {
        DriverManager.deregisterDriver(this.driver);
    }

    public void testReportedBug12400() throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null, 70, 1, 60000L, 10);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "username", "password");
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        Assert.assertNotNull((Object)poolableConnectionFactory);
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool("neusoftim", (ObjectPool)connectionPool);
        Connection[] conn = new Connection[25];
        int i = 0;
        while (i < 25) {
            conn[i] = DriverManager.getConnection("jdbc:apache:commons:dbcp:neusoftim");
            int j = 0;
            while (j < i) {
                Assert.assertTrue((conn[j] != conn[i] ? 1 : 0) != 0);
                Assert.assertTrue((!conn[j].equals(conn[i]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 25) {
            conn[i].close();
            ++i;
        }
    }
}

