/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.dbcp.TesterPreparedStatement;
import org.apache.commons.dbcp.TesterStatement;

public class TesterConnection
implements Connection {
    protected boolean _open = true;
    protected boolean _autoCommit = true;
    protected int _transactionIsolation = 1;
    protected DatabaseMetaData _metaData = null;
    protected String _catalog = null;
    protected Map _typeMap = null;
    protected boolean _readOnly = false;
    protected SQLWarning warnings = null;

    public void setWarnings(SQLWarning warning) {
        this.warnings = warning;
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.warnings = null;
    }

    public void close() throws SQLException {
        this.checkOpen();
        this._open = false;
    }

    public void commit() throws SQLException {
        this.checkOpen();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new TesterStatement(this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new TesterStatement(this);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._autoCommit;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._catalog;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._metaData;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.warnings;
    }

    public boolean isClosed() throws SQLException {
        return !this._open;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._readOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        if ("warning".equals(sql)) {
            this.setWarnings(new SQLWarning("warning in prepareCall"));
        }
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return null;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new TesterPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new TesterPreparedStatement(this, sql);
    }

    public void rollback() throws SQLException {
        this.checkOpen();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this._autoCommit = autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this._catalog = catalog;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this._readOnly = readOnly;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this._transactionIsolation = level;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._typeMap = map;
    }

    protected void checkOpen() throws SQLException {
        if (!this._open) {
            throw new SQLException("Connection is closed.");
        }
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }
}

