/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.TesterConnection;

public class TesterDriver
implements Driver {
    private static Properties validUserPasswords = new Properties();
    protected static String CONNECT_STRING;
    protected static int MAJOR_VERSION;
    protected static int MINOR_VERSION;

    static {
        try {
            DriverManager.registerDriver(new TesterDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        validUserPasswords.put("foo", "bar");
        validUserPasswords.put("u1", "p1");
        validUserPasswords.put("u2", "p2");
        validUserPasswords.put("username", "password");
        CONNECT_STRING = "jdbc:apache:commons:testdriver";
        MAJOR_VERSION = 1;
        MINOR_VERSION = 0;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return CONNECT_STRING.startsWith(url);
    }

    private void assertValidUserPassword(String user, String password) throws SQLException {
        String realPassword = validUserPasswords.getProperty(user);
        if (realPassword == null) {
            throw new SQLException(String.valueOf(user) + " is not a valid username.");
        }
        if (!realPassword.equals(password)) {
            throw new SQLException(String.valueOf(password) + " is not the correct password for " + user + ".  The correct password is " + realPassword);
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        TesterConnection conn = null;
        if (this.acceptsURL(url)) {
            if (info != null) {
                this.assertValidUserPassword(info.getProperty("user"), info.getProperty("password"));
            }
            conn = new TesterConnection();
        }
        return conn;
    }

    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }
}

