/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.commons.dbcp.TesterResultSet;

public class TesterStatement
implements Statement {
    protected Connection _connection = null;
    protected boolean _open = true;
    protected int _rowsUpdated = 1;
    protected boolean _executeResponse = true;
    protected int _maxFieldSize = 1024;
    protected int _maxRows = 1024;
    protected boolean _escapeProcessing = false;
    protected int _queryTimeout = 1000;
    protected String _cursorName = null;
    protected int _fetchDirection = 1;
    protected int _fetchSize = 1;
    protected int _resultSetConcurrency = 1;
    protected int _resultSetType = 1;

    public TesterStatement(Connection conn) {
        this._connection = conn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if ("null".equals(sql)) {
            return null;
        }
        return new TesterResultSet(this);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return this._rowsUpdated;
    }

    public void close() throws SQLException {
        this.checkOpen();
        this._open = false;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this._maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this._maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this._escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this._queryTimeout = seconds;
    }

    public void cancel() throws SQLException {
        this.checkOpen();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this._cursorName = name;
    }

    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        return this._executeResponse;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return new TesterResultSet(this);
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._rowsUpdated;
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this._fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this._fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._resultSetType;
    }

    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return new int[0];
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._connection;
    }

    protected void checkOpen() throws SQLException {
        if (!this._open) {
            throw new SQLException("Connection is closed.");
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        throw new SQLException("Not implemented.");
    }
}

