/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.cpdsadapter.ConnectionImpl;
import org.apache.commons.dbcp.cpdsadapter.PoolablePreparedStatementStub;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class PooledConnectionImpl
implements PooledConnection,
KeyedPoolableObjectFactory {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private Connection logicalConnection = null;
    private Vector eventListeners;
    boolean isClosed;
    protected KeyedObjectPool pstmtPool = null;

    PooledConnectionImpl(Connection connection, KeyedObjectPool pool) {
        this.connection = connection;
        this.eventListeners = new Vector();
        this.isClosed = false;
        if (pool != null) {
            this.pstmtPool = pool;
            this.pstmtPool.setFactory((KeyedPoolableObjectFactory)this);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        this.assertOpen();
        this.isClosed = true;
        try {
            block9: {
                try {
                    if (this.pstmtPool == null) break block9;
                    try {
                        this.pstmtPool.close();
                        Object var1_3 = null;
                        this.pstmtPool = null;
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        this.pstmtPool = null;
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLNestedException("Cannot close connection (return to pool failed)", e);
                }
            }
            Object var3_8 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.connection.close();
            throw throwable;
        }
        this.connection.close();
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection);
        return this.logicalConnection;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        ConnectionEvent event = new ConnectionEvent(this);
        Iterator i = this.eventListeners.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).connectionClosed(event);
        }
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    protected Object createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), resultSetType, resultSetConcurrency);
    }

    protected Object createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql));
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    public Object makeObject(Object obj) {
        try {
            if (obj == null || !(obj instanceof PStmtKey)) {
                throw new IllegalArgumentException();
            }
            PStmtKey key = (PStmtKey)obj;
            if (key._resultSetType == null && key._resultSetConcurrency == null) {
                return new PoolablePreparedStatementStub(this.connection.prepareStatement(key._sql), key, this.pstmtPool, this.connection);
            }
            return new PoolablePreparedStatementStub(this.connection.prepareStatement(key._sql, key._resultSetType, key._resultSetConcurrency), key, this.pstmtPool, this.connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)obj).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)obj).close();
        }
    }

    public boolean validateObject(Object key, Object obj) {
        return true;
    }

    public void activateObject(Object key, Object obj) {
        ((PoolablePreparedStatementStub)obj).activate();
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        ((PreparedStatement)obj).clearParameters();
        ((PoolablePreparedStatementStub)obj).passivate();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;

        PStmtKey(String sql) {
            this._sql = sql;
        }

        PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
            this._sql = sql;
            this._resultSetType = new Integer(resultSetType);
            this._resultSetConcurrency = new Integer(resultSetConcurrency);
        }

        public boolean equals(Object that) {
            try {
                PStmtKey key = (PStmtKey)that;
                return (this._sql == null && key._sql == null || this._sql.equals(key._sql)) && (this._resultSetType == null && key._resultSetType == null || this._resultSetType.equals(key._resultSetType)) && (this._resultSetConcurrency == null && key._resultSetConcurrency == null || this._resultSetConcurrency.equals(key._resultSetConcurrency));
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return this._sql == null ? 0 : this._sql.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("PStmtKey: sql=");
            buf.append(this._sql);
            buf.append(", resultSetType=");
            buf.append(this._resultSetType);
            buf.append(", resultSetConcurrency=");
            buf.append(this._resultSetConcurrency);
            return buf.toString();
        }
    }
}

