/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected String _username = null;
    protected String _password = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, String username, String password) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._validationQuery = validationQuery;
        this._username = username;
        this._password = password;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) throws SQLException {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLNestedException("Cannot set the pool on this factory", e);
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnectionAndInfo obj;
        try {
            PooledConnection pc = null;
            pc = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            pc.addConnectionEventListener(this);
            obj = new PooledConnectionAndInfo(pc, this._username, this._password);
            this.pcMap.put(pc, obj);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return obj;
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            ((PooledConnectionAndInfo)obj).getPooledConnection().close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateObject(Object obj) {
        valid = false;
        if (!(obj instanceof PooledConnectionAndInfo)) {
            return false;
        }
        pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
        query = this._validationQuery;
        if (query == null) {
            return true;
        }
        conn = null;
        stmt = null;
        rset = null;
        this.validatingMap.put(pconn, null);
        try {
            try {
                block19: {
                    conn = pconn.getConnection();
                    stmt = conn.createStatement();
                    rset = stmt.executeQuery(query);
                    if (!rset.next()) break block19;
                    valid = true;
                    ** GOTO lbl-1000
                }
                valid = false;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        catch (Throwable var10_9) {
            var9_10 = null;
            try {
                rset.close();
            }
            catch (Throwable var11_12) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable var11_12) {
                // empty catch block
            }
            try {
                conn.close();
            }
            catch (Throwable var11_12) {
                // empty catch block
            }
            this.validatingMap.remove(pconn);
            throw var10_9;
        }
lbl-1000:
        // 3 sources

        {
            block22: {
                block21: {
                    block20: {
                        var9_11 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 114->124)] { 
lbl53:
                        // 1 sources

                        rset.close();
                        break block20;
lbl55:
                        // 1 sources

                        catch (Throwable var11_13) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [4 : 126->136)] { 
lbl59:
                    // 1 sources

                    stmt.close();
                    break block21;
lbl61:
                    // 1 sources

                    catch (Throwable var11_13) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [5 : 138->148)] { 
lbl65:
                // 1 sources

                conn.close();
                break block22;
lbl67:
                // 1 sources

                catch (Throwable var11_13) {
                    // empty catch block
                }
            }
            this.validatingMap.remove(pconn);
            return valid;
        }
    }

    public void passivateObject(Object obj) {
    }

    public void activateObject(Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            Object info = this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                try {
                    this.destroyObject(info);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            if (event.getSQLException() != null) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
            }
            pc.removeConnectionEventListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.destroyObject(info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }
}

