/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected KeyedObjectPool _pool = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = validationQuery;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(KeyedObjectPool pool) throws SQLException {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLNestedException("Cannot set the pool on this factory", e);
            }
        }
        this._pool = pool;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object key) throws Exception {
        PooledConnectionAndInfo obj = null;
        UserPassKey upkey = (UserPassKey)key;
        PooledConnection pc = null;
        String username = upkey.getUsername();
        String password = upkey.getPassword();
        pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
        pc.addConnectionEventListener(this);
        obj = new PooledConnectionAndInfo(pc, username, password);
        this.pcMap.put(pc, obj);
        return obj;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            ((PooledConnectionAndInfo)obj).getPooledConnection().close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateObject(Object key, Object obj) {
        valid = false;
        if (!(obj instanceof PooledConnectionAndInfo)) {
            return false;
        }
        pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
        query = this._validationQuery;
        if (query == null) {
            return true;
        }
        conn = null;
        stmt = null;
        rset = null;
        this.validatingMap.put(pconn, null);
        try {
            try {
                block19: {
                    conn = pconn.getConnection();
                    stmt = conn.createStatement();
                    rset = stmt.executeQuery(query);
                    if (!rset.next()) break block19;
                    valid = true;
                    ** GOTO lbl-1000
                }
                valid = false;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        catch (Throwable var11_10) {
            var10_11 = null;
            try {
                rset.close();
            }
            catch (Throwable var12_13) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable var12_13) {
                // empty catch block
            }
            try {
                conn.close();
            }
            catch (Throwable var12_13) {
                // empty catch block
            }
            this.validatingMap.remove(pconn);
            throw var11_10;
        }
lbl-1000:
        // 3 sources

        {
            block22: {
                block21: {
                    block20: {
                        var10_12 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 117->127)] { 
lbl53:
                        // 1 sources

                        rset.close();
                        break block20;
lbl55:
                        // 1 sources

                        catch (Throwable var12_14) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [4 : 129->139)] { 
lbl59:
                    // 1 sources

                    stmt.close();
                    break block21;
lbl61:
                    // 1 sources

                    catch (Throwable var12_14) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [5 : 141->151)] { 
lbl65:
                // 1 sources

                conn.close();
                break block22;
lbl67:
                // 1 sources

                catch (Throwable var12_14) {
                    // empty catch block
                }
            }
            this.validatingMap.remove(pconn);
            return valid;
        }
    }

    public void passivateObject(Object key, Object obj) {
    }

    public void activateObject(Object key, Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject((Object)info.getUserPassKey(), (Object)info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                try {
                    this.destroyObject(info.getUserPassKey(), info);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            if (event.getSQLException() != null) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
            }
            pc.removeConnectionEventListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.destroyObject(info.getUserPassKey(), info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }
}

