/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.dbcp.TestConnectionPool;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;

public class TestSharedPoolDataSource
extends TestConnectionPool {
    private DataSource ds;
    private static int currentThreadCount = 0;
    static /* synthetic */ Class class$0;

    public TestSharedPoolDataSource(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.apache.commons.dbcp.datasources.TestSharedPoolDataSource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected Connection getConnection() throws Exception {
        return this.ds.getConnection("foo", "bar");
    }

    public void setUp() throws Exception {
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser("foo");
        pcds.setPassword("bar");
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.setConnectionPoolDataSource(pcds);
        tds.setMaxActive(this.getMaxActive());
        tds.setMaxWait((int)this.getMaxWait());
        this.ds = tds;
    }

    public void testIncorrectPassword() throws Exception {
        block4: {
            try {
                this.ds.getConnection("u1", "zlsafjk").close();
                Assert.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                this.ds.getConnection("u1", "x").close();
                Assert.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block4;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
    }

    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        ResultSet rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        ResultSet rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection("u1", "p1");
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        ResultSet rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try {
            conn.createStatement();
            Assert.fail((String)"Can't use closed connections");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assert.assertTrue((conn != null ? 1 : 0) != 0);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertTrue((stmt != null ? 1 : 0) != 0);
        rset = stmt.executeQuery();
        Assert.assertTrue((rset != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            int j = 0;
            while (j <= i) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.ds.getConnection();
            ++i;
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testMaxActive() throws Exception {
        Connection[] c = new Connection[this.getMaxActive()];
        int i22 = 0;
        while (i22 < c.length) {
            c[i22] = this.ds.getConnection();
            Assert.assertTrue((c[i22] != null ? 1 : 0) != 0);
            ++i22;
        }
        try {
            this.ds.getConnection();
            Assert.fail((String)"Allowed to open more than DefaultMaxActive connections.");
        }
        catch (SQLException i22) {
            // empty catch block
        }
        int i = 0;
        while (i < c.length) {
            c[i].close();
            ++i;
        }
    }

    public void testMultipleThreads() throws Exception {
        Assert.assertTrue((boolean)this.multipleThreads(1));
        Assert.assertTrue((!this.multipleThreads(2 * (int)this.getMaxWait()) ? 1 : 0) != 0);
    }

    private boolean multipleThreads(int holdTime) throws Exception {
        long startTime = System.currentTimeMillis();
        final boolean[] success = new boolean[]{true};
        final PoolTest[] pts = new PoolTest[2 * this.getMaxActive()];
        ThreadGroup threadGroup = new ThreadGroup("foo"){

            public void uncaughtException(Thread t, Throwable e) {
                int i = 0;
                while (i < pts.length) {
                    pts[i].stop();
                    ++i;
                }
                success[0] = false;
            }
        };
        int i = 0;
        while (i < pts.length) {
            pts[i] = new PoolTest(threadGroup, holdTime);
            ++i;
        }
        Thread.sleep(10 * holdTime);
        i = 0;
        while (i < pts.length) {
            pts[i].stop();
            ++i;
        }
        long time = System.currentTimeMillis() - startTime;
        System.out.println("Multithread test time = " + time + " ms");
        Thread.sleep(holdTime);
        return success[0];
    }

    private class PoolTest
    implements Runnable {
        private int connHoldTime;
        private boolean isRun;
        private String state;

        protected PoolTest(ThreadGroup threadGroup, int connHoldTime) {
            this.connHoldTime = connHoldTime;
            StringBuffer stringBuffer = new StringBuffer("Thread+");
            int n = currentThreadCount;
            currentThreadCount = n + 1;
            Thread thread = new Thread(threadGroup, this, stringBuffer.append(n).toString());
            thread.setDaemon(false);
            thread.start();
        }

        public void run() {
            this.isRun = true;
            while (this.isRun) {
                try {
                    Connection conn = null;
                    this.state = "Getting Connection";
                    conn = TestSharedPoolDataSource.this.getConnection();
                    this.state = "Using Connection";
                    Assert.assertTrue((conn != null ? 1 : 0) != 0);
                    PreparedStatement stmt = conn.prepareStatement("select * from dual");
                    Assert.assertTrue((stmt != null ? 1 : 0) != 0);
                    ResultSet rset = stmt.executeQuery();
                    Assert.assertTrue((rset != null ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)rset.next());
                    this.state = "Holding Connection";
                    Thread.sleep(this.connHoldTime);
                    this.state = "Returning Connection";
                    rset.close();
                    stmt.close();
                    conn.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }

        public void stop() {
            this.isRun = false;
        }

        public String reportState() {
            return this.state;
        }
    }
}

