/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.IOTimeoutException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogOutputStream;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnection {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpConnection == null ? (class$org$apache$commons$httpclient$HttpConnection = HttpConnection.class$("org.apache.commons.httpclient.HttpConnection")) : class$org$apache$commons$httpclient$HttpConnection));
    private boolean used = false;
    private String hostName = null;
    private String virtualName = null;
    private int portNumber = -1;
    private String proxyHostName = null;
    private int proxyPortNumber = -1;
    private Socket socket = null;
    private PushbackInputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream lastResponseInputStream = null;
    protected boolean isOpen = false;
    private Protocol protocolInUse;
    private HttpConnectionParams params = new HttpConnectionParams();
    private boolean locked = false;
    private boolean usingSecureSocket = false;
    private boolean tunnelEstablished = false;
    private HttpConnectionManager httpConnectionManager;
    private InetAddress localAddress;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpConnection;

    public HttpConnection(String host, int port) {
        this(null, -1, host, null, port, Protocol.getProtocol("http"));
    }

    public HttpConnection(String host, int port, Protocol protocol) {
        this(null, -1, host, null, port, protocol);
    }

    public HttpConnection(String host, String virtualHost, int port, Protocol protocol) {
        this(null, -1, host, virtualHost, port, protocol);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port) {
        this(proxyHost, proxyPort, host, null, port, Protocol.getProtocol("http"));
    }

    public HttpConnection(HostConfiguration hostConfiguration) {
        this(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), hostConfiguration.getHost(), hostConfiguration.getVirtualHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol());
        this.localAddress = hostConfiguration.getLocalAddress();
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, String virtualHost, int port, Protocol protocol) {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.proxyHostName = proxyHost;
        this.proxyPortNumber = proxyPort;
        this.hostName = host;
        this.virtualName = virtualHost;
        this.portNumber = protocol.resolvePort(port);
        this.protocolInUse = protocol;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public String getHost() {
        return this.hostName;
    }

    public void setHost(String host) throws IllegalStateException {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        this.assertNotOpen();
        this.hostName = host;
    }

    public String getVirtualHost() {
        return this.virtualName;
    }

    public void setVirtualHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.virtualName = host;
    }

    public int getPort() {
        if (this.portNumber < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return this.portNumber;
    }

    public void setPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.portNumber = port;
    }

    public String getProxyHost() {
        return this.proxyHostName;
    }

    public void setProxyHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyHostName = host;
    }

    public int getProxyPort() {
        return this.proxyPortNumber;
    }

    public void setProxyPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyPortNumber = port;
    }

    public boolean isSecure() {
        return this.protocolInUse.isSecure();
    }

    public Protocol getProtocol() {
        return this.protocolInUse;
    }

    public void setProtocol(Protocol protocol) {
        this.assertNotOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.protocolInUse = protocol;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.assertNotOpen();
        this.localAddress = localAddress;
    }

    public boolean isOpen() {
        if (this.used && this.params.isStaleCheckingEnabled() && this.isStale()) {
            LOG.debug((Object)"Connection is stale, closing...");
            this.close();
        }
        return this.isOpen;
    }

    public boolean isStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setStaleCheckingEnabled(boolean staleCheckEnabled) {
        this.params.setStaleCheckingEnabled(staleCheckEnabled);
    }

    protected boolean isStale() {
        boolean isStale;
        block8: {
            isStale = true;
            if (this.isOpen) {
                isStale = false;
                try {
                    if (this.inputStream.available() != 0) break block8;
                    try {
                        this.socket.setSoTimeout(1);
                        int byteRead = this.inputStream.read();
                        if (byteRead == -1) {
                            isStale = true;
                        } else {
                            this.inputStream.unread(byteRead);
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.socket.setSoTimeout(this.params.getSoTimeout());
                        throw throwable;
                    }
                    this.socket.setSoTimeout(this.params.getSoTimeout());
                    {
                    }
                }
                catch (IOTimeoutException e) {
                }
                catch (IOException e) {
                    LOG.debug((Object)"An error occurred while reading from the socket, is appears to be stale", (Throwable)e);
                    isStale = true;
                }
            }
        }
        return isStale;
    }

    public boolean isProxied() {
        return null != this.proxyHostName && 0 < this.proxyPortNumber;
    }

    public void setLastResponseInputStream(InputStream inStream) {
        this.lastResponseInputStream = inStream;
    }

    public InputStream getLastResponseInputStream() {
        return this.lastResponseInputStream;
    }

    public HttpConnectionParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = params;
    }

    public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
        this.params.setSoTimeout(timeout);
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public void setSocketTimeout(int timeout) throws SocketException, IllegalStateException {
        this.assertOpen();
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws SocketException {
        return this.params.getSoTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.params.setConnectionTimeout(timeout);
    }

    public void open() throws IOException {
        LOG.trace((Object)"enter HttpConnection.open()");
        String host = this.proxyHostName == null ? this.hostName : this.proxyHostName;
        int port = this.proxyHostName == null ? this.portNumber : this.proxyPortNumber;
        this.assertNotOpen();
        try {
            int rcvBufSize;
            if (this.socket == null) {
                this.usingSecureSocket = this.isSecure() && !this.isProxied();
                ProtocolSocketFactory socketFactory = this.isSecure() && this.isProxied() ? new DefaultProtocolSocketFactory() : this.protocolInUse.getSocketFactory();
                this.socket = socketFactory.createSocket(host, port, this.localAddress, 0, this.params);
            }
            this.socket.setTcpNoDelay(this.params.getTcpNoDelay());
            this.socket.setSoTimeout(this.params.getSoTimeout());
            int sndBufSize = this.params.getSendBufferSize();
            if (sndBufSize >= 0) {
                this.socket.setSendBufferSize(sndBufSize);
            }
            if ((rcvBufSize = this.params.getReceiveBufferSize()) >= 0) {
                this.socket.setReceiveBufferSize(rcvBufSize);
            }
            this.inputStream = new PushbackInputStream(new WrappedInputStream(this.socket.getInputStream()));
            this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
            this.isOpen = true;
            this.used = false;
        }
        catch (InterruptedIOException e) {
            this.closeSocketAndStreams();
            throw new ConnectTimeoutException("Open connection interrupted", e);
        }
        catch (IOException e) {
            this.closeSocketAndStreams();
            throw e;
        }
    }

    public void tunnelCreated() throws IllegalStateException, IOException {
        int rcvBufSize;
        LOG.trace((Object)"enter HttpConnection.tunnelCreated()");
        if (!this.isSecure() || !this.isProxied()) {
            throw new IllegalStateException("Connection must be secure and proxied to use this feature");
        }
        if (this.usingSecureSocket) {
            throw new IllegalStateException("Already using a secure socket");
        }
        SecureProtocolSocketFactory socketFactory = (SecureProtocolSocketFactory)this.protocolInUse.getSocketFactory();
        this.socket = socketFactory.createSocket(this.socket, this.hostName, this.portNumber, true);
        int sndBufSize = this.params.getSendBufferSize();
        if (sndBufSize >= 0) {
            this.socket.setSendBufferSize(sndBufSize);
        }
        if ((rcvBufSize = this.params.getReceiveBufferSize()) >= 0) {
            this.socket.setReceiveBufferSize(rcvBufSize);
        }
        this.inputStream = new PushbackInputStream(new WrappedInputStream(this.socket.getInputStream()));
        this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
        this.usingSecureSocket = true;
        this.tunnelEstablished = true;
        LOG.debug((Object)"Secure tunnel created");
    }

    public boolean isTransparent() {
        return !this.isProxied() || this.tunnelEstablished;
    }

    public void flushRequestOutputStream() throws IOException {
        LOG.trace((Object)"enter HttpConnection.flushRequestOutputStream()");
        this.assertOpen();
        this.outputStream.flush();
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getRequestOutputStream()");
        this.assertOpen();
        OutputStream out = this.outputStream;
        if (Wire.traceEnabled()) {
            out = new WireLogOutputStream(out);
        }
        return out;
    }

    public InputStream getResponseInputStream() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getResponseInputStream()");
        this.assertOpen();
        return this.inputStream;
    }

    public boolean isResponseAvailable() throws IOException {
        LOG.trace((Object)"enter HttpConnection.isResponseAvailable()");
        this.assertOpen();
        return this.inputStream.available() > 0;
    }

    /*
     * Loose catch block
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        boolean result;
        block13: {
            LOG.trace((Object)"enter HttpConnection.isResponseAvailable(int)");
            this.assertOpen();
            result = false;
            if (this.inputStream.available() > 0) {
                result = true;
            } else {
                block12: {
                    this.socket.setSoTimeout(timeout);
                    int byteRead = this.inputStream.read();
                    if (byteRead != -1) {
                        this.inputStream.unread(byteRead);
                        LOG.debug((Object)"Input data available");
                        result = true;
                        break block12;
                    }
                    LOG.debug((Object)"Input data not available");
                }
                Object var5_5 = null;
                try {
                    this.socket.setSoTimeout(this.params.getSoTimeout());
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"An error ocurred while resetting soTimeout, we will assume that no response is available.", (Throwable)ioe);
                    result = false;
                }
            }
            break block13;
            {
                catch (IOTimeoutException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Input data not available after " + timeout + " ms"));
                    }
                    Object var5_6 = null;
                    try {
                        this.socket.setSoTimeout(this.params.getSoTimeout());
                    }
                    catch (IOException ioe) {
                        LOG.debug((Object)"An error ocurred while resetting soTimeout, we will assume that no response is available.", (Throwable)ioe);
                        result = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.socket.setSoTimeout(this.params.getSoTimeout());
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"An error ocurred while resetting soTimeout, we will assume that no response is available.", (Throwable)ioe);
                    result = false;
                }
                throw throwable;
            }
        }
        return result;
    }

    public void write(byte[] data) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.write(byte[])");
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.write(byte[], int, int)");
        if (offset < 0) {
            throw new IllegalArgumentException("Array offset may not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Array length may not be negative");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Given offset and length exceed the array length");
        }
        this.assertOpen();
        this.outputStream.write(data, offset, length);
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.writeLine(byte[])");
        this.write(data);
        this.writeLine();
    }

    public void writeLine() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.writeLine()");
        this.write(CRLF);
    }

    public void print(String data) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.print(String)");
        this.write(EncodingUtil.getBytes(data, "ISO-8859-1"));
    }

    public void print(String data, String charset) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.print(String)");
        this.write(EncodingUtil.getBytes(data, charset));
    }

    public void printLine(String data) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.printLine(String)");
        this.writeLine(EncodingUtil.getBytes(data, "ISO-8859-1"));
    }

    public void printLine(String data, String charset) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.printLine(String)");
        this.writeLine(EncodingUtil.getBytes(data, charset));
    }

    public void printLine() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.printLine()");
        this.writeLine();
    }

    public String readLine() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream);
    }

    public String readLine(String charset) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream, charset);
    }

    public void shutdownOutput() {
        LOG.trace((Object)"enter HttpConnection.shutdownOutput()");
        try {
            Class[] paramsClasses = new Class[]{};
            Method shutdownOutput = this.socket.getClass().getMethod("shutdownOutput", paramsClasses);
            Object[] params = new Object[]{};
            shutdownOutput.invoke((Object)this.socket, params);
        }
        catch (Exception ex) {
            LOG.debug((Object)"Unexpected Exception caught", (Throwable)ex);
        }
    }

    public void close() {
        LOG.trace((Object)"enter HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void releaseConnection() {
        LOG.trace((Object)"enter HttpConnection.releaseConnection()");
        if (this.locked) {
            LOG.debug((Object)"Connection is locked.  Call to releaseConnection() ignored.");
        } else if (this.httpConnectionManager != null) {
            LOG.debug((Object)"Releasing connection back to connection manager.");
            this.httpConnectionManager.releaseConnection(this);
        } else {
            LOG.warn((Object)"HttpConnectionManager is null.  Connection cannot be released.");
        }
    }

    boolean isLocked() {
        return this.locked;
    }

    void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected void closeSocketAndStreams() {
        Closeable temp;
        LOG.trace((Object)"enter HttpConnection.closeSockedAndStreams()");
        this.lastResponseInputStream = null;
        if (null != this.outputStream) {
            temp = this.outputStream;
            this.outputStream = null;
            try {
                ((OutputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing output", (Throwable)ex);
            }
        }
        if (null != this.inputStream) {
            temp = this.inputStream;
            this.inputStream = null;
            try {
                ((InputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing input", (Throwable)ex);
            }
        }
        if (null != this.socket) {
            temp = this.socket;
            this.socket = null;
            try {
                ((Socket)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing socket", (Throwable)ex);
            }
        }
        this.isOpen = false;
        this.used = false;
        this.tunnelEstablished = false;
        this.usingSecureSocket = false;
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this.isOpen) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSendBufferSize();
    }

    public void setSendBufferSize(int sendBufferSize) throws SocketException {
        this.params.setSendBufferSize(sendBufferSize);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WrappedInputStream
    extends InputStream {
        private InputStream in;

        public WrappedInputStream(InputStream in) {
            this.in = in;
        }

        private IOException handleException(IOException ioe) {
            if (ioe instanceof InterruptedIOException) {
                return new IOTimeoutException(ioe.getMessage());
            }
            return ioe;
        }

        public int read() throws IOException {
            try {
                return this.in.read();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.in.read(b, off, len);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return this.in.read(b);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public int available() throws IOException {
            try {
                return this.in.available();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }
    }

    private class WrappedOutputStream
    extends OutputStream {
        private OutputStream out;

        public WrappedOutputStream(OutputStream out) {
            this.out = out;
        }

        private IOException handleException(IOException ioe) {
            boolean isRecoverable = HttpConnection.this.used;
            HttpConnection.this.close();
            if (ioe instanceof InterruptedIOException) {
                return new IOTimeoutException(ioe.getMessage());
            }
            if (isRecoverable) {
                LOG.debug((Object)"Output exception occurred on a used connection.  Will treat as recoverable.", (Throwable)ioe);
                return new HttpRecoverableException(ioe.getMessage(), ioe);
            }
            return ioe;
        }

        public void write(int b) throws IOException {
            try {
                this.out.write(b);
                HttpConnection.this.used = true;
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void close() throws IOException {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.out.write(b, off, len);
                HttpConnection.this.used = true;
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b) throws IOException {
            try {
                this.out.write(b);
                HttpConnection.this.used = true;
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }
    }
}

